/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.jersey.server.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import shadow.org.glassfish.jersey.Severity;
import shadow.org.glassfish.jersey.internal.Errors;
import shadow.org.glassfish.jersey.message.MessageBodyWorkers;
import shadow.org.glassfish.jersey.server.model.InvocableValidator;
import shadow.org.glassfish.jersey.server.model.ResourceMethodValidator;
import shadow.org.glassfish.jersey.server.model.ResourceModelComponent;
import shadow.org.glassfish.jersey.server.model.ResourceModelIssue;
import shadow.org.glassfish.jersey.server.model.ResourceModelVisitor;
import shadow.org.glassfish.jersey.server.model.ResourceValidator;
import shadow.org.glassfish.jersey.server.model.RuntimeResourceModelValidator;
import shadow.org.glassfish.jersey.server.model.internal.ModelErrors;
import shadow.org.glassfish.jersey.server.spi.internal.ValueParamProvider;

public final class ComponentModelValidator {
    private final List<ResourceModelIssue> issueList = new LinkedList<ResourceModelIssue>();
    private final List<ResourceModelVisitor> validators = new ArrayList<ResourceModelVisitor>();

    public ComponentModelValidator(Collection<ValueParamProvider> valueParamProviders, MessageBodyWorkers msgBodyWorkers) {
        this.validators.add(new ResourceValidator());
        this.validators.add(new RuntimeResourceModelValidator(msgBodyWorkers));
        this.validators.add(new ResourceMethodValidator(valueParamProviders));
        this.validators.add(new InvocableValidator());
    }

    public List<ResourceModelIssue> getIssueList() {
        return this.issueList;
    }

    public boolean fatalIssuesFound() {
        for (ResourceModelIssue issue : this.getIssueList()) {
            if (issue.getSeverity() != Severity.FATAL) continue;
            return true;
        }
        return false;
    }

    public void cleanIssueList() {
        this.issueList.clear();
    }

    public void validate(final ResourceModelComponent component) {
        Errors.process(new Runnable(){

            @Override
            public void run() {
                Errors.mark();
                ComponentModelValidator.this.validateWithErrors(component);
                ComponentModelValidator.this.issueList.addAll(ModelErrors.getErrorsAsResourceModelIssues(true));
                Errors.unmark();
            }
        });
    }

    private void validateWithErrors(ResourceModelComponent component) {
        for (ResourceModelVisitor validator : this.validators) {
            component.accept(validator);
        }
        List<? extends ResourceModelComponent> componentList = component.getComponents();
        if (null != componentList) {
            for (ResourceModelComponent resourceModelComponent : componentList) {
                this.validateWithErrors(resourceModelComponent);
            }
        }
    }
}

