/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.jersey.server.internal.inject;

import java.util.function.Function;
import shadow.javax.inject.Provider;
import shadow.javax.inject.Singleton;
import shadow.javax.ws.rs.BadRequestException;
import shadow.javax.ws.rs.container.ContainerRequestContext;
import shadow.javax.ws.rs.core.Request;
import shadow.javax.ws.rs.core.Response;
import shadow.org.glassfish.jersey.model.Parameter;
import shadow.org.glassfish.jersey.server.ContainerRequest;
import shadow.org.glassfish.jersey.server.internal.LocalizationMessages;
import shadow.org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import shadow.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import shadow.org.glassfish.jersey.server.model.Parameter;

@Singleton
class EntityParamValueParamProvider
extends AbstractValueParamProvider {
    EntityParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, Parameter.Source.ENTITY);
    }

    @Override
    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        return new EntityValueSupplier(parameter);
    }

    private static class EntityValueSupplier
    implements Function<ContainerRequest, Object> {
        private final Parameter parameter;

        public EntityValueSupplier(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Object apply(ContainerRequest containerRequest) {
            ContainerRequest value;
            Class<?> rawType = this.parameter.getRawType();
            if ((Request.class.isAssignableFrom(rawType) || ContainerRequestContext.class.isAssignableFrom(rawType)) && rawType.isInstance(containerRequest)) {
                value = containerRequest;
            } else {
                value = containerRequest.readEntity(rawType, this.parameter.getType(), this.parameter.getAnnotations());
                if (rawType.isPrimitive() && value == null) {
                    throw new BadRequestException(Response.status(Response.Status.BAD_REQUEST).entity(LocalizationMessages.ERROR_PRIMITIVE_TYPE_NULL()).build());
                }
            }
            return value;
        }
    }
}

