/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.jersey.server.internal.inject;

import java.lang.reflect.ParameterizedType;
import java.util.function.Function;
import shadow.javax.inject.Singleton;
import shadow.org.glassfish.jersey.internal.inject.Binding;
import shadow.org.glassfish.jersey.internal.inject.Bindings;
import shadow.org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import shadow.org.glassfish.jersey.internal.inject.ForeignDescriptor;
import shadow.org.glassfish.jersey.internal.inject.Injectee;
import shadow.org.glassfish.jersey.internal.inject.InjecteeImpl;
import shadow.org.glassfish.jersey.internal.util.collection.Cache;
import shadow.org.glassfish.jersey.internal.util.collection.LazyValue;
import shadow.org.glassfish.jersey.model.Parameter;
import shadow.org.glassfish.jersey.process.internal.RequestScoped;
import shadow.org.glassfish.jersey.server.ContainerRequest;
import shadow.org.glassfish.jersey.server.model.Parameter;
import shadow.org.glassfish.jersey.server.spi.internal.ValueParamProvider;

@Singleton
class DelegatedInjectionValueParamProvider
implements ValueParamProvider {
    private final LazyValue<ContextInjectionResolver> resolver;
    private final Function<Binding, ForeignDescriptor> foreignDescriptorFactory;
    private final Cache<Parameter, ForeignDescriptor> descriptorCache = new Cache<Parameter, ForeignDescriptor>(parameter -> {
        Class<?> rawType = parameter.getRawType();
        if (rawType.isInterface() && !(parameter.getType() instanceof ParameterizedType)) {
            return this.createDescriptor(rawType);
        }
        return null;
    });

    public DelegatedInjectionValueParamProvider(LazyValue<ContextInjectionResolver> resolver, Function<Binding, ForeignDescriptor> foreignDescriptorFactory) {
        this.resolver = resolver;
        this.foreignDescriptorFactory = foreignDescriptorFactory;
    }

    @Override
    public Function<ContainerRequest, ?> getValueProvider(Parameter parameter) {
        Parameter.Source paramSource = parameter.getSource();
        if (paramSource == Parameter.Source.CONTEXT) {
            return containerRequest -> ((ContextInjectionResolver)this.resolver.get()).resolve(this.getInjectee(parameter));
        }
        return null;
    }

    @Override
    public ValueParamProvider.PriorityType getPriority() {
        return ValueParamProvider.Priority.LOW;
    }

    private Injectee getInjectee(Parameter parameter) {
        InjecteeImpl injectee = new InjecteeImpl();
        injectee.setRequiredType(parameter.getType());
        injectee.setInjecteeClass(parameter.getRawType());
        ForeignDescriptor proxyDescriptor = this.descriptorCache.apply(parameter);
        if (proxyDescriptor != null) {
            injectee.setInjecteeDescriptor(proxyDescriptor);
        }
        return injectee;
    }

    private ForeignDescriptor createDescriptor(Class<?> clazz) {
        return this.foreignDescriptorFactory.apply((Binding)Bindings.serviceAsContract(clazz).in(RequestScoped.class));
    }
}

