/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.jersey.server.internal;

import java.io.IOException;
import shadow.javax.annotation.Priority;
import shadow.javax.inject.Singleton;
import shadow.javax.ws.rs.InternalServerErrorException;
import shadow.javax.ws.rs.WebApplicationException;
import shadow.javax.ws.rs.ext.ReaderInterceptor;
import shadow.javax.ws.rs.ext.ReaderInterceptorContext;
import shadow.javax.ws.rs.ext.WriterInterceptor;
import shadow.javax.ws.rs.ext.WriterInterceptorContext;
import shadow.org.glassfish.jersey.internal.inject.AbstractBinder;
import shadow.org.glassfish.jersey.internal.inject.ClassBinding;
import shadow.org.glassfish.jersey.message.internal.MessageBodyProviderNotFoundException;
import shadow.org.glassfish.jersey.server.internal.process.MappableException;

@Priority(value=10)
@Singleton
public class MappableExceptionWrapperInterceptor
implements ReaderInterceptor,
WriterInterceptor {
    @Override
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            return context.proceed();
        }
        catch (WebApplicationException | MessageBodyProviderNotFoundException | MappableException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappableException(e);
        }
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (WebApplicationException | MappableException e) {
            throw e;
        }
        catch (MessageBodyProviderNotFoundException nfe) {
            throw new InternalServerErrorException(nfe);
        }
        catch (Exception e) {
            throw new MappableException(e);
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(MappableExceptionWrapperInterceptor.class).to(ReaderInterceptor.class)).to(WriterInterceptor.class)).in(Singleton.class);
        }
    }
}

