/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.jersey.message.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import shadow.javax.inject.Provider;
import shadow.javax.inject.Singleton;
import shadow.javax.ws.rs.BadRequestException;
import shadow.javax.ws.rs.Consumes;
import shadow.javax.ws.rs.InternalServerErrorException;
import shadow.javax.ws.rs.Produces;
import shadow.javax.ws.rs.core.Context;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.MultivaluedMap;
import shadow.javax.ws.rs.ext.MessageBodyReader;
import shadow.javax.ws.rs.ext.MessageBodyWriter;
import shadow.javax.xml.parsers.DocumentBuilderFactory;
import shadow.javax.xml.parsers.ParserConfigurationException;
import shadow.javax.xml.parsers.SAXParserFactory;
import shadow.javax.xml.transform.Result;
import shadow.javax.xml.transform.Source;
import shadow.javax.xml.transform.TransformerException;
import shadow.javax.xml.transform.TransformerFactory;
import shadow.javax.xml.transform.dom.DOMSource;
import shadow.javax.xml.transform.sax.SAXSource;
import shadow.javax.xml.transform.stream.StreamResult;
import shadow.javax.xml.transform.stream.StreamSource;
import shadow.org.xml.sax.InputSource;
import shadow.org.xml.sax.SAXException;
import shadow.org.xml.sax.SAXParseException;

@Singleton
public final class SourceProvider {

    @Produces(value={"application/xml", "text/xml", "*/*"})
    @Consumes(value={"application/xml", "text/xml", "*/*"})
    @Singleton
    public static final class SourceWriter
    implements MessageBodyWriter<Source> {
        private final Provider<SAXParserFactory> saxParserFactory;
        private final Provider<TransformerFactory> transformerFactory;

        public SourceWriter(@Context Provider<SAXParserFactory> spf, @Context Provider<TransformerFactory> tf) {
            this.saxParserFactory = spf;
            this.transformerFactory = tf;
        }

        @Override
        public boolean isWriteable(Class<?> t, Type gt, Annotation[] as, MediaType mediaType) {
            return Source.class.isAssignableFrom(t);
        }

        @Override
        public long getSize(Source o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return -1L;
        }

        @Override
        public void writeTo(Source source, Class<?> t, Type gt, Annotation[] as, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
            try {
                if (source instanceof StreamSource) {
                    StreamSource stream = (StreamSource)source;
                    InputSource inputStream = new InputSource(stream.getInputStream());
                    inputStream.setCharacterStream(inputStream.getCharacterStream());
                    inputStream.setPublicId(stream.getPublicId());
                    inputStream.setSystemId(source.getSystemId());
                    source = new SAXSource(this.saxParserFactory.get().newSAXParser().getXMLReader(), inputStream);
                }
                StreamResult sr = new StreamResult(entityStream);
                this.transformerFactory.get().newTransformer().transform(source, (Result)sr);
            }
            catch (SAXException ex) {
                throw new InternalServerErrorException(ex);
            }
            catch (ParserConfigurationException ex) {
                throw new InternalServerErrorException(ex);
            }
            catch (TransformerException ex) {
                throw new InternalServerErrorException(ex);
            }
        }
    }

    @Produces(value={"application/xml", "text/xml", "*/*"})
    @Consumes(value={"application/xml", "text/xml", "*/*"})
    @Singleton
    public static final class DomSourceReader
    implements MessageBodyReader<DOMSource> {
        private final Provider<DocumentBuilderFactory> dbf;

        public DomSourceReader(@Context Provider<DocumentBuilderFactory> dbf) {
            this.dbf = dbf;
        }

        @Override
        public boolean isReadable(Class<?> t, Type gt, Annotation[] as, MediaType mediaType) {
            return DOMSource.class == t;
        }

        @Override
        public DOMSource readFrom(Class<DOMSource> t, Type gt, Annotation[] as, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
            try {
                Document d = this.dbf.get().newDocumentBuilder().parse(entityStream);
                return new DOMSource((Node)d);
            }
            catch (SAXParseException ex) {
                throw new BadRequestException(ex);
            }
            catch (SAXException ex) {
                throw new InternalServerErrorException(ex);
            }
            catch (ParserConfigurationException ex) {
                throw new InternalServerErrorException(ex);
            }
        }
    }

    @Produces(value={"application/xml", "text/xml", "*/*"})
    @Consumes(value={"application/xml", "text/xml", "*/*"})
    @Singleton
    public static final class SaxSourceReader
    implements MessageBodyReader<SAXSource> {
        private final Provider<SAXParserFactory> spf;

        public SaxSourceReader(@Context Provider<SAXParserFactory> spf) {
            this.spf = spf;
        }

        @Override
        public boolean isReadable(Class<?> t, Type gt, Annotation[] as, MediaType mediaType) {
            return SAXSource.class == t;
        }

        @Override
        public SAXSource readFrom(Class<SAXSource> t, Type gt, Annotation[] as, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
            try {
                return new SAXSource(this.spf.get().newSAXParser().getXMLReader(), new InputSource(entityStream));
            }
            catch (SAXParseException ex) {
                throw new BadRequestException(ex);
            }
            catch (SAXException ex) {
                throw new InternalServerErrorException(ex);
            }
            catch (ParserConfigurationException ex) {
                throw new InternalServerErrorException(ex);
            }
        }
    }

    @Produces(value={"application/xml", "text/xml", "*/*"})
    @Consumes(value={"application/xml", "text/xml", "*/*"})
    @Singleton
    public static final class StreamSourceReader
    implements MessageBodyReader<StreamSource> {
        @Override
        public boolean isReadable(Class<?> t, Type gt, Annotation[] as, MediaType mediaType) {
            return StreamSource.class == t || Source.class == t;
        }

        @Override
        public StreamSource readFrom(Class<StreamSource> t, Type gt, Annotation[] as, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
            return new StreamSource(entityStream);
        }
    }
}

