/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.glassfish.jersey.message.internal;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import shadow.javax.imageio.ImageIO;
import shadow.javax.imageio.ImageReader;
import shadow.javax.imageio.ImageWriter;
import shadow.javax.imageio.stream.ImageInputStream;
import shadow.javax.inject.Singleton;
import shadow.javax.ws.rs.Consumes;
import shadow.javax.ws.rs.Produces;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.MultivaluedMap;
import shadow.org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;

@Produces(value={"image/*"})
@Consumes(value={"image/*", "application/octet-stream"})
@Singleton
public final class RenderedImageProvider
extends AbstractMessageReaderWriterProvider<RenderedImage> {
    private static final MediaType IMAGE_MEDIA_TYPE = new MediaType("image", "*");

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return RenderedImage.class == type || BufferedImage.class == type;
    }

    @Override
    public RenderedImage readFrom(Class<RenderedImage> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        if (IMAGE_MEDIA_TYPE.isCompatible(mediaType)) {
            Iterator readers = ImageIO.getImageReadersByMIMEType((String)mediaType.toString());
            if (!readers.hasNext()) {
                throw new IOException("The image-based media type " + mediaType + "is not supported for reading");
            }
            ImageReader reader = (ImageReader)readers.next();
            ImageInputStream in = ImageIO.createImageInputStream((Object)entityStream);
            reader.setInput((Object)in, true, true);
            BufferedImage bi = reader.read(0, reader.getDefaultReadParam());
            in.close();
            reader.dispose();
            return bi;
        }
        return ImageIO.read((InputStream)entityStream);
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return RenderedImage.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(RenderedImage t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        String formatName = this.getWriterFormatName(mediaType);
        if (formatName == null) {
            throw new IOException("The image-based media type " + mediaType + " is not supported for writing");
        }
        ImageIO.write((RenderedImage)t, (String)formatName, (OutputStream)entityStream);
    }

    private String getWriterFormatName(MediaType t) {
        return this.getWriterFormatName(t.toString());
    }

    private String getWriterFormatName(String t) {
        Iterator i = ImageIO.getImageWritersByMIMEType((String)t);
        if (!i.hasNext()) {
            return null;
        }
        return ((ImageWriter)i.next()).getOriginatingProvider().getFormatNames()[0];
    }
}

