/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.commonmark.internal.inline;

import shadow.org.commonmark.node.Emphasis;
import shadow.org.commonmark.node.Node;
import shadow.org.commonmark.node.StrongEmphasis;
import shadow.org.commonmark.node.Text;
import shadow.org.commonmark.parser.delimiter.DelimiterProcessor;
import shadow.org.commonmark.parser.delimiter.DelimiterRun;

public abstract class EmphasisDelimiterProcessor
implements DelimiterProcessor {
    private final char delimiterChar;

    protected EmphasisDelimiterProcessor(char delimiterChar) {
        this.delimiterChar = delimiterChar;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delimiterChar;
    }

    @Override
    public char getClosingCharacter() {
        return this.delimiterChar;
    }

    @Override
    public int getMinLength() {
        return 1;
    }

    @Override
    public int getDelimiterUse(DelimiterRun opener, DelimiterRun closer) {
        if ((opener.canClose() || closer.canOpen()) && (opener.originalLength() + closer.originalLength()) % 3 == 0) {
            return 0;
        }
        if (opener.length() >= 2 && closer.length() >= 2) {
            return 2;
        }
        return 1;
    }

    @Override
    public void process(Text opener, Text closer, int delimiterUse) {
        String singleDelimiter = String.valueOf(this.getOpeningCharacter());
        Node emphasis = delimiterUse == 1 ? new Emphasis(singleDelimiter) : new StrongEmphasis(singleDelimiter + singleDelimiter);
        Node tmp = opener.getNext();
        while (tmp != null && tmp != closer) {
            Node next = tmp.getNext();
            emphasis.appendChild(tmp);
            tmp = next;
        }
        opener.insertAfter(emphasis);
    }
}

