/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.commonmark.internal;

import shadow.org.commonmark.internal.BlockContent;
import shadow.org.commonmark.internal.ReferenceParser;
import shadow.org.commonmark.internal.util.Parsing;
import shadow.org.commonmark.node.Block;
import shadow.org.commonmark.node.Paragraph;
import shadow.org.commonmark.parser.InlineParser;
import shadow.org.commonmark.parser.block.AbstractBlockParser;
import shadow.org.commonmark.parser.block.BlockContinue;
import shadow.org.commonmark.parser.block.ParserState;

public class ParagraphParser
extends AbstractBlockParser {
    private final Paragraph block = new Paragraph();
    private BlockContent content = new BlockContent();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (!state.isBlank()) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(CharSequence line) {
        this.content.add(line);
    }

    @Override
    public void closeBlock() {
    }

    public void closeBlock(ReferenceParser inlineParser) {
        int pos;
        String contentString = this.content.getString();
        boolean hasReferenceDefs = false;
        while (contentString.length() > 3 && contentString.charAt(0) == '[' && (pos = inlineParser.parseReference(contentString)) != 0) {
            contentString = contentString.substring(pos);
            hasReferenceDefs = true;
        }
        if (hasReferenceDefs && Parsing.isBlank(contentString)) {
            this.block.unlink();
            this.content = null;
        } else {
            this.content = new BlockContent(contentString);
        }
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        if (this.content != null) {
            inlineParser.parse(this.content.getString(), this.block);
        }
    }

    public String getContentString() {
        return this.content.getString();
    }
}

