/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.commonmark.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.org.commonmark.node.Block;
import shadow.org.commonmark.node.Heading;
import shadow.org.commonmark.parser.InlineParser;
import shadow.org.commonmark.parser.block.AbstractBlockParser;
import shadow.org.commonmark.parser.block.AbstractBlockParserFactory;
import shadow.org.commonmark.parser.block.BlockContinue;
import shadow.org.commonmark.parser.block.BlockStart;
import shadow.org.commonmark.parser.block.MatchedBlockParser;
import shadow.org.commonmark.parser.block.ParserState;

public class HeadingParser
extends AbstractBlockParser {
    private static Pattern ATX_HEADING = Pattern.compile("^#{1,6}(?:[ \t]+|$)");
    private static Pattern ATX_TRAILING = Pattern.compile("(^| ) *#+ *$");
    private static Pattern SETEXT_HEADING = Pattern.compile("^(?:=+|-+) *$");
    private final Heading block = new Heading();
    private final String content;

    public HeadingParser(int level, String content) {
        this.block.setLevel(level);
        this.content = content;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        return BlockContinue.none();
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        inlineParser.parse(this.content, this.block);
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            CharSequence line = state.getLine();
            int nextNonSpace = state.getNextNonSpaceIndex();
            CharSequence paragraph = matchedBlockParser.getParagraphContent();
            Matcher matcher = ATX_HEADING.matcher(line.subSequence(nextNonSpace, line.length()));
            if (matcher.find()) {
                int newOffset = nextNonSpace + matcher.group(0).length();
                int level = matcher.group(0).trim().length();
                String content = ATX_TRAILING.matcher(line.subSequence(newOffset, line.length())).replaceAll("");
                return BlockStart.of(new HeadingParser(level, content)).atIndex(line.length());
            }
            if (paragraph != null && (matcher = SETEXT_HEADING.matcher(line.subSequence(nextNonSpace, line.length()))).find()) {
                int level = matcher.group(0).charAt(0) == '=' ? 1 : 2;
                String content = paragraph.toString();
                return BlockStart.of(new HeadingParser(level, content)).atIndex(line.length()).replaceActiveBlockParser();
            }
            return BlockStart.none();
        }
    }
}

