/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.commonmark.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.org.commonmark.internal.util.Escaping;
import shadow.org.commonmark.node.Block;
import shadow.org.commonmark.node.FencedCodeBlock;
import shadow.org.commonmark.parser.block.AbstractBlockParser;
import shadow.org.commonmark.parser.block.AbstractBlockParserFactory;
import shadow.org.commonmark.parser.block.BlockContinue;
import shadow.org.commonmark.parser.block.BlockStart;
import shadow.org.commonmark.parser.block.MatchedBlockParser;
import shadow.org.commonmark.parser.block.ParserState;

public class FencedCodeBlockParser
extends AbstractBlockParser {
    private static final Pattern OPENING_FENCE = Pattern.compile("^`{3,}(?!.*`)|^~{3,}(?!.*~)");
    private static final Pattern CLOSING_FENCE = Pattern.compile("^(?:`{3,}|~{3,})(?= *$)");
    private final FencedCodeBlock block = new FencedCodeBlock();
    private String firstLine;
    private StringBuilder otherLines = new StringBuilder();

    public FencedCodeBlockParser(char fenceChar, int fenceLength, int fenceIndent) {
        this.block.setFenceChar(fenceChar);
        this.block.setFenceLength(fenceLength);
        this.block.setFenceIndent(fenceIndent);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        boolean matches;
        int nextNonSpace = state.getNextNonSpaceIndex();
        int newIndex = state.getIndex();
        CharSequence line = state.getLine();
        Matcher matcher = null;
        boolean bl = matches = state.getIndent() <= 3 && nextNonSpace < line.length() && line.charAt(nextNonSpace) == this.block.getFenceChar() && (matcher = CLOSING_FENCE.matcher(line.subSequence(nextNonSpace, line.length()))).find();
        if (matches && matcher.group(0).length() >= this.block.getFenceLength()) {
            return BlockContinue.finished();
        }
        for (int i = this.block.getFenceIndent(); i > 0 && newIndex < line.length() && line.charAt(newIndex) == ' '; ++newIndex, --i) {
        }
        return BlockContinue.atIndex(newIndex);
    }

    @Override
    public void addLine(CharSequence line) {
        if (this.firstLine == null) {
            this.firstLine = line.toString();
        } else {
            this.otherLines.append(line);
            this.otherLines.append('\n');
        }
    }

    @Override
    public void closeBlock() {
        this.block.setInfo(Escaping.unescapeString(this.firstLine.trim()));
        this.block.setLiteral(this.otherLines.toString());
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            Matcher matcher;
            int nextNonSpace = state.getNextNonSpaceIndex();
            CharSequence line = state.getLine();
            if (state.getIndent() < 4 && (matcher = OPENING_FENCE.matcher(line.subSequence(nextNonSpace, line.length()))).find()) {
                int fenceLength = matcher.group(0).length();
                char fenceChar = matcher.group(0).charAt(0);
                FencedCodeBlockParser blockParser = new FencedCodeBlockParser(fenceChar, fenceLength, state.getIndent());
                return BlockStart.of(blockParser).atIndex(nextNonSpace + fenceLength);
            }
            return BlockStart.none();
        }
    }
}

