/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.commonmark.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.org.commonmark.internal.BlockContinueImpl;
import shadow.org.commonmark.internal.BlockQuoteParser;
import shadow.org.commonmark.internal.BlockStartImpl;
import shadow.org.commonmark.internal.DocumentBlockParser;
import shadow.org.commonmark.internal.FencedCodeBlockParser;
import shadow.org.commonmark.internal.HeadingParser;
import shadow.org.commonmark.internal.HtmlBlockParser;
import shadow.org.commonmark.internal.IndentedCodeBlockParser;
import shadow.org.commonmark.internal.ListBlockParser;
import shadow.org.commonmark.internal.ParagraphParser;
import shadow.org.commonmark.internal.ReferenceParser;
import shadow.org.commonmark.internal.ThematicBreakParser;
import shadow.org.commonmark.internal.util.Parsing;
import shadow.org.commonmark.internal.util.Substring;
import shadow.org.commonmark.node.Block;
import shadow.org.commonmark.node.BlockQuote;
import shadow.org.commonmark.node.Document;
import shadow.org.commonmark.node.FencedCodeBlock;
import shadow.org.commonmark.node.Heading;
import shadow.org.commonmark.node.HtmlBlock;
import shadow.org.commonmark.node.IndentedCodeBlock;
import shadow.org.commonmark.node.ListBlock;
import shadow.org.commonmark.node.ListItem;
import shadow.org.commonmark.node.Node;
import shadow.org.commonmark.node.Paragraph;
import shadow.org.commonmark.node.ThematicBreak;
import shadow.org.commonmark.parser.InlineParser;
import shadow.org.commonmark.parser.block.AbstractBlockParserFactory;
import shadow.org.commonmark.parser.block.BlockContinue;
import shadow.org.commonmark.parser.block.BlockParser;
import shadow.org.commonmark.parser.block.BlockParserFactory;
import shadow.org.commonmark.parser.block.BlockStart;
import shadow.org.commonmark.parser.block.MatchedBlockParser;
import shadow.org.commonmark.parser.block.ParserState;

public class DocumentParser
implements ParserState {
    private static final Set<Class<? extends Block>> CORE_FACTORY_TYPES = new LinkedHashSet<Class>(Arrays.asList(BlockQuote.class, Heading.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, ListBlock.class, IndentedCodeBlock.class));
    private static final Map<Class<? extends Block>, BlockParserFactory> NODES_TO_CORE_FACTORIES;
    private CharSequence line;
    private int index = 0;
    private int column = 0;
    private boolean columnIsInTab;
    private int nextNonSpace = 0;
    private int nextNonSpaceColumn = 0;
    private int indent = 0;
    private boolean blank;
    private final List<BlockParserFactory> blockParserFactories;
    private final InlineParser inlineParser;
    private final DocumentBlockParser documentBlockParser;
    private List<BlockParser> activeBlockParsers = new ArrayList<BlockParser>();
    private Set<BlockParser> allBlockParsers = new HashSet<BlockParser>();
    private Map<Node, Boolean> lastLineBlank = new HashMap<Node, Boolean>();

    public DocumentParser(List<BlockParserFactory> blockParserFactories, InlineParser inlineParser) {
        this.blockParserFactories = blockParserFactories;
        this.inlineParser = inlineParser;
        this.documentBlockParser = new DocumentBlockParser();
        this.activateBlockParser(this.documentBlockParser);
    }

    public static Set<Class<? extends Block>> getDefaultBlockParserTypes() {
        return CORE_FACTORY_TYPES;
    }

    public static List<BlockParserFactory> calculateBlockParserFactories(List<BlockParserFactory> customBlockParserFactories, Set<Class<? extends Block>> enabledBlockTypes) {
        ArrayList<BlockParserFactory> list = new ArrayList<BlockParserFactory>();
        list.addAll(customBlockParserFactories);
        for (Class<? extends Block> blockType : enabledBlockTypes) {
            list.add(NODES_TO_CORE_FACTORIES.get(blockType));
        }
        return list;
    }

    public Document parse(String input) {
        int lineBreak;
        int lineStart = 0;
        while ((lineBreak = Parsing.findLineBreak(input, lineStart)) != -1) {
            CharSequence line = Substring.of(input, lineStart, lineBreak);
            this.incorporateLine(line);
            if (lineBreak + 1 < input.length() && input.charAt(lineBreak) == '\r' && input.charAt(lineBreak + 1) == '\n') {
                lineStart = lineBreak + 2;
                continue;
            }
            lineStart = lineBreak + 1;
        }
        if (input.length() > 0 && (lineStart == 0 || lineStart < input.length())) {
            this.incorporateLine(Substring.of(input, lineStart, input.length()));
        }
        return this.finalizeAndProcess();
    }

    public Document parse(Reader input) throws IOException {
        String line;
        BufferedReader bufferedReader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        while ((line = bufferedReader.readLine()) != null) {
            this.incorporateLine(line);
        }
        return this.finalizeAndProcess();
    }

    @Override
    public CharSequence getLine() {
        return this.line;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getNextNonSpaceIndex() {
        return this.nextNonSpace;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public int getIndent() {
        return this.indent;
    }

    @Override
    public boolean isBlank() {
        return this.blank;
    }

    @Override
    public BlockParser getActiveBlockParser() {
        return this.activeBlockParsers.get(this.activeBlockParsers.size() - 1);
    }

    private void incorporateLine(CharSequence ln) {
        boolean tryBlockStarts;
        BlockParser lastMatchedBlockParser;
        this.line = Parsing.prepareLine(ln);
        this.index = 0;
        this.column = 0;
        this.columnIsInTab = false;
        int matches = 1;
        for (BlockParser blockParser : this.activeBlockParsers.subList(1, this.activeBlockParsers.size())) {
            this.findNextNonSpace();
            BlockContinue result = blockParser.tryContinue(this);
            if (!(result instanceof BlockContinueImpl)) break;
            BlockContinueImpl blockContinue = (BlockContinueImpl)result;
            if (blockContinue.isFinalize()) {
                this.finalize(blockParser);
                return;
            }
            if (blockContinue.getNewIndex() != -1) {
                this.setNewIndex(blockContinue.getNewIndex());
            } else if (blockContinue.getNewColumn() != -1) {
                this.setNewColumn(blockContinue.getNewColumn());
            }
            ++matches;
        }
        ArrayList<BlockParser> unmatchedBlockParsers = new ArrayList<BlockParser>(this.activeBlockParsers.subList(matches, this.activeBlockParsers.size()));
        BlockParser blockParser = lastMatchedBlockParser = this.activeBlockParsers.get(matches - 1);
        boolean allClosed = unmatchedBlockParsers.isEmpty();
        boolean bl = tryBlockStarts = blockParser.getBlock() instanceof Paragraph || blockParser.isContainer();
        while (tryBlockStarts) {
            this.findNextNonSpace();
            if (this.isBlank() || this.indent < Parsing.CODE_BLOCK_INDENT && Parsing.isLetter(this.line, this.nextNonSpace)) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            BlockStartImpl blockStart = this.findBlockStart(blockParser);
            if (blockStart == null) {
                this.setNewIndex(this.nextNonSpace);
                break;
            }
            if (!allClosed) {
                this.finalizeBlocks(unmatchedBlockParsers);
                allClosed = true;
            }
            if (blockStart.getNewIndex() != -1) {
                this.setNewIndex(blockStart.getNewIndex());
            } else if (blockStart.getNewColumn() != -1) {
                this.setNewColumn(blockStart.getNewColumn());
            }
            if (blockStart.isReplaceActiveBlockParser()) {
                this.removeActiveBlockParser();
            }
            for (BlockParser newBlockParser : blockStart.getBlockParsers()) {
                blockParser = this.addChild(newBlockParser);
                tryBlockStarts = newBlockParser.isContainer();
            }
        }
        if (!allClosed && !this.isBlank() && this.getActiveBlockParser() instanceof ParagraphParser) {
            this.addLine();
        } else {
            if (!allClosed) {
                this.finalizeBlocks(unmatchedBlockParsers);
            }
            this.propagateLastLineBlank(blockParser, lastMatchedBlockParser);
            if (!blockParser.isContainer()) {
                this.addLine();
            } else if (!this.isBlank()) {
                this.addChild(new ParagraphParser());
                this.addLine();
            }
        }
    }

    private void findNextNonSpace() {
        int i = this.index;
        int cols = this.column;
        this.blank = true;
        block4: while (i < this.line.length()) {
            char c = this.line.charAt(i);
            switch (c) {
                case ' ': {
                    ++i;
                    ++cols;
                    continue block4;
                }
                case '\t': {
                    ++i;
                    cols += 4 - cols % 4;
                    continue block4;
                }
            }
            this.blank = false;
            break;
        }
        this.nextNonSpace = i;
        this.nextNonSpaceColumn = cols;
        this.indent = this.nextNonSpaceColumn - this.column;
    }

    private void setNewIndex(int newIndex) {
        if (newIndex >= this.nextNonSpace) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        while (this.index < newIndex && this.index != this.line.length()) {
            this.advance();
        }
        this.columnIsInTab = false;
    }

    private void setNewColumn(int newColumn) {
        if (newColumn >= this.nextNonSpaceColumn) {
            this.index = this.nextNonSpace;
            this.column = this.nextNonSpaceColumn;
        }
        while (this.column < newColumn && this.index != this.line.length()) {
            this.advance();
        }
        if (this.column > newColumn) {
            --this.index;
            this.column = newColumn;
            this.columnIsInTab = true;
        } else {
            this.columnIsInTab = false;
        }
    }

    private void advance() {
        char c = this.line.charAt(this.index);
        if (c == '\t') {
            ++this.index;
            this.column += Parsing.columnsToNextTabStop(this.column);
        } else {
            ++this.index;
            ++this.column;
        }
    }

    private void addLine() {
        CharSequence content;
        if (this.columnIsInTab) {
            int afterTab = this.index + 1;
            CharSequence rest = this.line.subSequence(afterTab, this.line.length());
            int spaces = Parsing.columnsToNextTabStop(this.column);
            StringBuilder sb = new StringBuilder(spaces + rest.length());
            for (int i = 0; i < spaces; ++i) {
                sb.append(' ');
            }
            sb.append(rest);
            content = sb.toString();
        } else {
            content = this.line.subSequence(this.index, this.line.length());
        }
        this.getActiveBlockParser().addLine(content);
    }

    private BlockStartImpl findBlockStart(BlockParser blockParser) {
        MatchedBlockParserImpl matchedBlockParser = new MatchedBlockParserImpl(blockParser);
        for (BlockParserFactory blockParserFactory : this.blockParserFactories) {
            BlockStart result = blockParserFactory.tryStart(this, matchedBlockParser);
            if (!(result instanceof BlockStartImpl)) continue;
            return (BlockStartImpl)result;
        }
        return null;
    }

    private void finalize(BlockParser blockParser) {
        if (this.getActiveBlockParser() == blockParser) {
            this.deactivateBlockParser();
        }
        blockParser.closeBlock();
        if (blockParser instanceof ParagraphParser && this.inlineParser instanceof ReferenceParser) {
            ParagraphParser paragraphParser = (ParagraphParser)blockParser;
            paragraphParser.closeBlock((ReferenceParser)((Object)this.inlineParser));
        } else if (blockParser instanceof ListBlockParser) {
            ListBlockParser listBlockParser = (ListBlockParser)blockParser;
            this.finalizeListTight(listBlockParser);
        }
    }

    private void processInlines() {
        for (BlockParser blockParser : this.allBlockParsers) {
            blockParser.parseInlines(this.inlineParser);
        }
    }

    private void finalizeListTight(ListBlockParser listBlockParser) {
        block0: for (Node item = listBlockParser.getBlock().getFirstChild(); item != null; item = item.getNext()) {
            if (this.endsWithBlankLine(item) && item.getNext() != null) {
                listBlockParser.setTight(false);
                break;
            }
            for (Node subItem = item.getFirstChild(); subItem != null; subItem = subItem.getNext()) {
                if (!this.endsWithBlankLine(subItem) || item.getNext() == null && subItem.getNext() == null) continue;
                listBlockParser.setTight(false);
                continue block0;
            }
        }
    }

    private boolean endsWithBlankLine(Node block) {
        while (block != null) {
            if (this.isLastLineBlank(block)) {
                return true;
            }
            if (!(block instanceof ListBlock) && !(block instanceof ListItem)) break;
            block = block.getLastChild();
        }
        return false;
    }

    private <T extends BlockParser> T addChild(T blockParser) {
        while (!this.getActiveBlockParser().canContain(blockParser.getBlock())) {
            this.finalize(this.getActiveBlockParser());
        }
        this.getActiveBlockParser().getBlock().appendChild(blockParser.getBlock());
        this.activateBlockParser(blockParser);
        return blockParser;
    }

    private void activateBlockParser(BlockParser blockParser) {
        this.activeBlockParsers.add(blockParser);
        this.allBlockParsers.add(blockParser);
    }

    private void deactivateBlockParser() {
        this.activeBlockParsers.remove(this.activeBlockParsers.size() - 1);
    }

    private void removeActiveBlockParser() {
        BlockParser old = this.getActiveBlockParser();
        this.deactivateBlockParser();
        this.allBlockParsers.remove(old);
        old.getBlock().unlink();
    }

    private void propagateLastLineBlank(BlockParser blockParser, BlockParser lastMatchedBlockParser) {
        if (this.isBlank() && blockParser.getBlock().getLastChild() != null) {
            this.setLastLineBlank(blockParser.getBlock().getLastChild(), true);
        }
        Block block = blockParser.getBlock();
        boolean lastLineBlank = this.isBlank() && !(block instanceof BlockQuote) && !(block instanceof FencedCodeBlock) && (!(block instanceof ListItem) || block.getFirstChild() != null || blockParser == lastMatchedBlockParser);
        for (Node node = blockParser.getBlock(); node != null; node = ((Node)node).getParent()) {
            this.setLastLineBlank(node, lastLineBlank);
        }
    }

    private void setLastLineBlank(Node node, boolean value) {
        this.lastLineBlank.put(node, value);
    }

    private boolean isLastLineBlank(Node node) {
        Boolean value = this.lastLineBlank.get(node);
        return value != null && value != false;
    }

    private boolean finalizeBlocks(List<BlockParser> blockParsers) {
        for (int i = blockParsers.size() - 1; i >= 0; --i) {
            BlockParser blockParser = blockParsers.get(i);
            this.finalize(blockParser);
        }
        return true;
    }

    private Document finalizeAndProcess() {
        this.finalizeBlocks(this.activeBlockParsers);
        this.processInlines();
        return this.documentBlockParser.getBlock();
    }

    static {
        HashMap<Class<IndentedCodeBlock>, AbstractBlockParserFactory> map = new HashMap<Class<IndentedCodeBlock>, AbstractBlockParserFactory>();
        map.put(BlockQuote.class, new BlockQuoteParser.Factory());
        map.put(Heading.class, new HeadingParser.Factory());
        map.put(FencedCodeBlock.class, new FencedCodeBlockParser.Factory());
        map.put(HtmlBlock.class, new HtmlBlockParser.Factory());
        map.put(ThematicBreak.class, new ThematicBreakParser.Factory());
        map.put(ListBlock.class, new ListBlockParser.Factory());
        map.put(IndentedCodeBlock.class, new IndentedCodeBlockParser.Factory());
        NODES_TO_CORE_FACTORIES = Collections.unmodifiableMap(map);
    }

    private static class MatchedBlockParserImpl
    implements MatchedBlockParser {
        private final BlockParser matchedBlockParser;

        public MatchedBlockParserImpl(BlockParser matchedBlockParser) {
            this.matchedBlockParser = matchedBlockParser;
        }

        @Override
        public BlockParser getMatchedBlockParser() {
            return this.matchedBlockParser;
        }

        @Override
        public CharSequence getParagraphContent() {
            if (this.matchedBlockParser instanceof ParagraphParser) {
                ParagraphParser paragraphParser = (ParagraphParser)this.matchedBlockParser;
                return paragraphParser.getContentString();
            }
            return null;
        }
    }
}

