/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import shadow.org.commonmark.ext.gfm.tables.TableBlock;
import shadow.org.commonmark.ext.gfm.tables.TableBody;
import shadow.org.commonmark.ext.gfm.tables.TableCell;
import shadow.org.commonmark.ext.gfm.tables.TableHead;
import shadow.org.commonmark.ext.gfm.tables.TableRow;
import shadow.org.commonmark.node.Block;
import shadow.org.commonmark.node.CustomNode;
import shadow.org.commonmark.parser.InlineParser;
import shadow.org.commonmark.parser.block.AbstractBlockParser;
import shadow.org.commonmark.parser.block.AbstractBlockParserFactory;
import shadow.org.commonmark.parser.block.BlockContinue;
import shadow.org.commonmark.parser.block.BlockStart;
import shadow.org.commonmark.parser.block.MatchedBlockParser;
import shadow.org.commonmark.parser.block.ParserState;

public class TableBlockParser
extends AbstractBlockParser {
    private static String COL = "\\s*:?-{3,}:?\\s*";
    private static Pattern TABLE_HEADER_SEPARATOR = Pattern.compile("\\|" + COL + "\\|?\\s*|" + COL + "\\|\\s*|\\|?(?:" + COL + "\\|)+" + COL + "\\|?\\s*");
    private final TableBlock block = new TableBlock();
    private final List<CharSequence> rowLines = new ArrayList<CharSequence>();
    private boolean nextIsSeparatorLine = true;
    private String separatorLine = "";

    private TableBlockParser(CharSequence headerLine) {
        this.rowLines.add(headerLine);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.getLine().toString().contains("|")) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(CharSequence line) {
        if (this.nextIsSeparatorLine) {
            this.nextIsSeparatorLine = false;
            this.separatorLine = line.toString();
        } else {
            this.rowLines.add(line);
        }
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        CustomNode section = new TableHead();
        this.block.appendChild(section);
        List<TableCell.Alignment> alignments = TableBlockParser.parseAlignment(this.separatorLine);
        int headerColumns = -1;
        boolean header = true;
        for (CharSequence rowLine : this.rowLines) {
            List<String> cells = TableBlockParser.split(rowLine);
            TableRow tableRow = new TableRow();
            if (headerColumns == -1) {
                headerColumns = cells.size();
            }
            for (int i = 0; i < headerColumns; ++i) {
                String cell = i < cells.size() ? cells.get(i) : "";
                TableCell.Alignment alignment = i < alignments.size() ? alignments.get(i) : null;
                TableCell tableCell = new TableCell();
                tableCell.setHeader(header);
                tableCell.setAlignment(alignment);
                inlineParser.parse(cell.trim(), tableCell);
                tableRow.appendChild(tableCell);
            }
            section.appendChild(tableRow);
            if (!header) continue;
            header = false;
            section = new TableBody();
            this.block.appendChild(section);
        }
    }

    private static List<TableCell.Alignment> parseAlignment(String separatorLine) {
        List<String> parts = TableBlockParser.split(separatorLine);
        ArrayList<TableCell.Alignment> alignments = new ArrayList<TableCell.Alignment>();
        for (String part : parts) {
            String trimmed = part.trim();
            boolean left = trimmed.startsWith(":");
            boolean right = trimmed.endsWith(":");
            TableCell.Alignment alignment = TableBlockParser.getAlignment(left, right);
            alignments.add(alignment);
        }
        return alignments;
    }

    private static List<String> split(CharSequence input) {
        String line = input.toString().trim();
        if (line.startsWith("|")) {
            line = line.substring(1);
        }
        ArrayList<String> cells = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        block4: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (escape) {
                escape = false;
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    escape = true;
                    sb.append(c);
                    continue block4;
                }
                case '|': {
                    cells.add(sb.toString());
                    sb.setLength(0);
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            cells.add(sb.toString());
        }
        return cells;
    }

    private static TableCell.Alignment getAlignment(boolean left, boolean right) {
        if (left && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            CharSequence line = state.getLine();
            CharSequence paragraph = matchedBlockParser.getParagraphContent();
            if (paragraph != null && paragraph.toString().contains("|") && !paragraph.toString().contains("\n")) {
                CharSequence separatorLine = line.subSequence(state.getIndex(), line.length());
                if (TABLE_HEADER_SEPARATOR.matcher(separatorLine).matches()) {
                    List headParts = TableBlockParser.split(paragraph);
                    List separatorParts = TableBlockParser.split(separatorLine);
                    if (separatorParts.size() >= headParts.size()) {
                        return BlockStart.of(new TableBlockParser(paragraph)).atIndex(state.getIndex()).replaceActiveBlockParser();
                    }
                }
            }
            return BlockStart.none();
        }
    }
}

