/*
 * Decompiled with CFR 0.152.
 */
package shadow.javax.el;

import java.lang.reflect.Method;
import shadow.javax.el.BeanNameELResolver;
import shadow.javax.el.BeanNameResolver;
import shadow.javax.el.ELContext;
import shadow.javax.el.ELException;
import shadow.javax.el.ELResolver;
import shadow.javax.el.ELUtil;
import shadow.javax.el.EvaluationListener;
import shadow.javax.el.ExpressionFactory;
import shadow.javax.el.StandardELContext;
import shadow.javax.el.ValueExpression;

public class ELManager {
    private StandardELContext elContext;

    public static ExpressionFactory getExpressionFactory() {
        return ELUtil.getExpressionFactory();
    }

    public StandardELContext getELContext() {
        if (this.elContext == null) {
            this.elContext = new StandardELContext(ELManager.getExpressionFactory());
        }
        return this.elContext;
    }

    public ELContext setELContext(ELContext context) {
        StandardELContext prevELContext = this.elContext;
        this.elContext = new StandardELContext(context);
        return prevELContext;
    }

    public void addBeanNameResolver(BeanNameResolver beanNameResolver) {
        this.getELContext().addELResolver(new BeanNameELResolver(beanNameResolver));
    }

    public void addELResolver(ELResolver elResolver) {
        this.getELContext().addELResolver(elResolver);
    }

    public void mapFunction(String prefix, String function, Method method) {
        this.getELContext().getFunctionMapper().mapFunction(prefix, function, method);
    }

    public void setVariable(String variable, ValueExpression expression) {
        this.getELContext().getVariableMapper().setVariable(variable, expression);
    }

    public void importStatic(String staticMemberName) throws ELException {
        this.getELContext().getImportHandler().importStatic(staticMemberName);
    }

    public void importClass(String className) throws ELException {
        this.getELContext().getImportHandler().importClass(className);
    }

    public void importPackage(String packageName) {
        this.getELContext().getImportHandler().importPackage(packageName);
    }

    public Object defineBean(String name, Object bean) {
        Object previousBean = this.getELContext().getBeans().get(name);
        this.getELContext().getBeans().put(name, bean);
        return previousBean;
    }

    public void addEvaluationListener(EvaluationListener listener) {
        this.getELContext().addEvaluationListener(listener);
    }
}

