/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.swagger.v3.core.util;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.fasterxml.jackson.databind.ObjectReader;
import shadow.io.swagger.v3.core.util.Json;
import shadow.io.swagger.v3.oas.models.parameters.CookieParameter;
import shadow.io.swagger.v3.oas.models.parameters.HeaderParameter;
import shadow.io.swagger.v3.oas.models.parameters.Parameter;
import shadow.io.swagger.v3.oas.models.parameters.PathParameter;
import shadow.io.swagger.v3.oas.models.parameters.QueryParameter;

public class ParameterDeserializer
extends JsonDeserializer<Parameter> {
    @Override
    public Parameter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Parameter result = null;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode sub = node.get("$ref");
        JsonNode inNode = node.get("in");
        if (sub != null) {
            result = new Parameter().$ref(sub.asText());
        } else if (inNode != null) {
            String in = inNode.asText();
            ObjectReader reader = null;
            if ("query".equals(in)) {
                reader = Json.mapper().readerFor(QueryParameter.class);
            } else if ("header".equals(in)) {
                reader = Json.mapper().readerFor(HeaderParameter.class);
            } else if ("path".equals(in)) {
                reader = Json.mapper().readerFor(PathParameter.class);
            } else if ("cookie".equals(in)) {
                reader = Json.mapper().readerFor(CookieParameter.class);
            }
            if (reader != null) {
                result = (Parameter)reader.with(DeserializationFeature.READ_ENUMS_USING_TO_STRING).readValue(node);
            }
        }
        return result;
    }
}

