/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.swagger.v3.core.util;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.fasterxml.jackson.databind.node.ObjectNode;
import shadow.com.fasterxml.jackson.databind.node.TextNode;
import shadow.io.swagger.v3.core.util.Json;
import shadow.io.swagger.v3.oas.models.media.ArraySchema;
import shadow.io.swagger.v3.oas.models.media.BooleanSchema;
import shadow.io.swagger.v3.oas.models.media.ComposedSchema;
import shadow.io.swagger.v3.oas.models.media.DateSchema;
import shadow.io.swagger.v3.oas.models.media.DateTimeSchema;
import shadow.io.swagger.v3.oas.models.media.EmailSchema;
import shadow.io.swagger.v3.oas.models.media.IntegerSchema;
import shadow.io.swagger.v3.oas.models.media.MapSchema;
import shadow.io.swagger.v3.oas.models.media.NumberSchema;
import shadow.io.swagger.v3.oas.models.media.ObjectSchema;
import shadow.io.swagger.v3.oas.models.media.PasswordSchema;
import shadow.io.swagger.v3.oas.models.media.Schema;
import shadow.io.swagger.v3.oas.models.media.StringSchema;
import shadow.io.swagger.v3.oas.models.media.UUIDSchema;
import shadow.org.apache.commons.lang3.StringUtils;

public class ModelDeserializer
extends JsonDeserializer<Schema> {
    @Override
    public Schema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String format;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode allOf = node.get("allOf");
        JsonNode anyOf = node.get("anyOf");
        JsonNode oneOf = node.get("oneOf");
        Schema schema = null;
        if (allOf != null || anyOf != null || oneOf != null) {
            return Json.mapper().convertValue((Object)node, ComposedSchema.class);
        }
        JsonNode type = node.get("type");
        String string = format = node.get("format") == null ? "" : node.get("format").textValue();
        if (type != null && "array".equals(((TextNode)type).textValue())) {
            schema = Json.mapper().convertValue((Object)node, ArraySchema.class);
        } else if (type != null) {
            if (type.textValue().equals("integer")) {
                schema = Json.mapper().convertValue((Object)node, IntegerSchema.class);
                if (StringUtils.isBlank(format)) {
                    schema.setFormat(null);
                }
            } else if (type.textValue().equals("number")) {
                schema = Json.mapper().convertValue((Object)node, NumberSchema.class);
            } else if (type.textValue().equals("boolean")) {
                schema = Json.mapper().convertValue((Object)node, BooleanSchema.class);
            } else if (type.textValue().equals("string")) {
                schema = "date".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, DateSchema.class) : ("date-time".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, DateTimeSchema.class) : ("email".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, EmailSchema.class) : ("password".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, PasswordSchema.class) : ("uuid".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, UUIDSchema.class) : (Schema)Json.mapper().convertValue((Object)node, StringSchema.class)))));
            } else if (type.textValue().equals("object")) {
                schema = this.deserializeObjectSchema(node);
            }
        } else {
            schema = node.get("$ref") != null ? new Schema().$ref(node.get("$ref").asText()) : this.deserializeObjectSchema(node);
        }
        return schema;
    }

    private Schema deserializeObjectSchema(JsonNode node) {
        JsonNode additionalProperties = node.get("additionalProperties");
        Schema schema = null;
        if (additionalProperties != null) {
            try {
                Schema innerSchema = Json.mapper().convertValue((Object)additionalProperties, Schema.class);
                ((ObjectNode)node).remove("additionalProperties");
                MapSchema ms = Json.mapper().convertValue((Object)node, MapSchema.class);
                ms.setAdditionalProperties(innerSchema);
                schema = ms;
            }
            catch (Exception e) {
                Boolean additionalPropsBoolean = Json.mapper().convertValue((Object)additionalProperties, Boolean.class);
                schema = additionalPropsBoolean != false ? (Schema)Json.mapper().convertValue((Object)node, MapSchema.class) : (Schema)Json.mapper().convertValue((Object)node, ObjectSchema.class);
                schema.setAdditionalProperties(additionalPropsBoolean);
            }
        } else {
            schema = Json.mapper().convertValue((Object)node, ObjectSchema.class);
        }
        return schema;
    }
}

