/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.swagger.v3.core.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.fasterxml.jackson.databind.node.ObjectNode;
import shadow.io.swagger.v3.core.util.Json;
import shadow.io.swagger.v3.oas.models.PathItem;
import shadow.io.swagger.v3.oas.models.callbacks.Callback;

public class CallbackDeserializer
extends JsonDeserializer<Callback> {
    @Override
    public Callback deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        Callback result = new Callback();
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        ObjectNode objectNode = (ObjectNode)node;
        LinkedHashMap<String, Object> extensions = new LinkedHashMap<String, Object>();
        Iterator<String> it = objectNode.fieldNames();
        while (it.hasNext()) {
            String childName = it.next();
            JsonNode child = objectNode.get(childName);
            if (childName.startsWith("x-")) {
                extensions.put(childName, Json.mapper().convertValue((Object)child, Object.class));
                continue;
            }
            if (childName.equals("$ref")) {
                result.$ref(child.asText());
                continue;
            }
            result.put(childName, Json.mapper().convertValue((Object)child, PathItem.class));
        }
        if (!extensions.isEmpty()) {
            result.setExtensions(extensions);
        }
        return result;
    }
}

