/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.swagger.v3.core.jackson;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.com.fasterxml.jackson.databind.JsonSerializer;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import shadow.io.swagger.v3.oas.models.media.Schema;
import shadow.org.apache.commons.lang3.StringUtils;

public class SchemaSerializer
extends JsonSerializer<Schema>
implements ResolvableSerializer {
    private JsonSerializer<Object> defaultSerializer;

    public SchemaSerializer(JsonSerializer<Object> serializer) {
        this.defaultSerializer = serializer;
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        if (this.defaultSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)this.defaultSerializer)).resolve(serializerProvider);
        }
    }

    @Override
    public void serialize(Schema value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (StringUtils.isBlank(value.get$ref())) {
            if (value.getExampleSetFlag() && value.getExample() == null) {
                jgen.writeStartObject();
                this.defaultSerializer.unwrappingSerializer(null).serialize(value, jgen, provider);
                jgen.writeNullField("example");
                jgen.writeEndObject();
            } else {
                this.defaultSerializer.serialize(value, jgen, provider);
            }
        } else {
            jgen.writeStartObject();
            jgen.writeStringField("$ref", value.get$ref());
            jgen.writeEndObject();
        }
    }
}

