/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.observers;

import java.util.concurrent.atomic.AtomicReference;
import shadow.io.reactivex.rxjava3.annotations.NonNull;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.internal.util.EndConsumerHelper;

public abstract class DisposableObserver<T>
implements Observer<T>,
Disposable {
    final AtomicReference<Disposable> upstream = new AtomicReference();

    @Override
    public final void onSubscribe(@NonNull Disposable d) {
        if (EndConsumerHelper.setOnce(this.upstream, d, this.getClass())) {
            this.onStart();
        }
    }

    protected void onStart() {
    }

    @Override
    public final boolean isDisposed() {
        return this.upstream.get() == DisposableHelper.DISPOSED;
    }

    @Override
    public final void dispose() {
        DisposableHelper.dispose(this.upstream);
    }
}

