/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.single;

import java.util.concurrent.TimeUnit;
import shadow.io.reactivex.rxjava3.annotations.NonNull;
import shadow.io.reactivex.rxjava3.core.Scheduler;
import shadow.io.reactivex.rxjava3.core.Single;
import shadow.io.reactivex.rxjava3.core.SingleObserver;
import shadow.io.reactivex.rxjava3.core.SingleSource;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.schedulers.Timed;

public final class SingleTimeInterval<T>
extends Single<Timed<T>> {
    final SingleSource<T> source;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean start;

    public SingleTimeInterval(SingleSource<T> source, TimeUnit unit, Scheduler scheduler, boolean start) {
        this.source = source;
        this.unit = unit;
        this.scheduler = scheduler;
        this.start = start;
    }

    @Override
    protected void subscribeActual(@NonNull @NonNull SingleObserver<? super @NonNull Timed<T>> observer) {
        this.source.subscribe(new TimeIntervalSingleObserver(observer, this.unit, this.scheduler, this.start));
    }

    static final class TimeIntervalSingleObserver<T>
    implements SingleObserver<T>,
    Disposable {
        final SingleObserver<? super Timed<T>> downstream;
        final TimeUnit unit;
        final Scheduler scheduler;
        final long startTime;
        Disposable upstream;

        TimeIntervalSingleObserver(SingleObserver<? super Timed<T>> downstream, TimeUnit unit, Scheduler scheduler, boolean start) {
            this.downstream = downstream;
            this.unit = unit;
            this.scheduler = scheduler;
            this.startTime = start ? scheduler.now(unit) : 0L;
        }

        @Override
        public void onSubscribe(@NonNull Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(@NonNull T t) {
            this.downstream.onSuccess(new Timed<T>(t, this.scheduler.now(this.unit) - this.startTime, this.unit));
        }

        @Override
        public void onError(@NonNull Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

