/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.single;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.core.Single;
import shadow.io.reactivex.rxjava3.core.SingleObserver;
import shadow.io.reactivex.rxjava3.core.SingleOperator;
import shadow.io.reactivex.rxjava3.core.SingleSource;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.internal.disposables.EmptyDisposable;

public final class SingleLift<T, R>
extends Single<R> {
    final SingleSource<T> source;
    final SingleOperator<? extends R, ? super T> onLift;

    public SingleLift(SingleSource<T> source, SingleOperator<? extends R, ? super T> onLift) {
        this.source = source;
        this.onLift = onLift;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        SingleObserver<? super T> sr;
        try {
            sr = Objects.requireNonNull(this.onLift.apply(observer), "The onLift returned a null SingleObserver");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.source.subscribe(sr);
    }
}

