/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.single;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.core.Single;
import shadow.io.reactivex.rxjava3.core.SingleObserver;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Supplier;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SingleFromSupplier<T>
extends Single<T> {
    final Supplier<? extends T> supplier;

    public SingleFromSupplier(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        T value;
        Disposable d = Disposable.empty();
        observer.onSubscribe(d);
        if (d.isDisposed()) {
            return;
        }
        try {
            value = Objects.requireNonNull(this.supplier.get(), "The supplier returned a null value");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            if (!d.isDisposed()) {
                observer.onError(ex);
            } else {
                RxJavaPlugins.onError(ex);
            }
            return;
        }
        if (!d.isDisposed()) {
            observer.onSuccess(value);
        }
    }
}

