/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.single;

import java.util.concurrent.atomic.AtomicInteger;
import shadow.io.reactivex.rxjava3.core.Single;
import shadow.io.reactivex.rxjava3.core.SingleObserver;
import shadow.io.reactivex.rxjava3.core.SingleSource;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Action;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class SingleDoFinally<T>
extends Single<T> {
    final SingleSource<T> source;
    final Action onFinally;

    public SingleDoFinally(SingleSource<T> source, Action onFinally) {
        this.source = source;
        this.onFinally = onFinally;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super T> observer) {
        this.source.subscribe(new DoFinallyObserver<T>(observer, this.onFinally));
    }

    static final class DoFinallyObserver<T>
    extends AtomicInteger
    implements SingleObserver<T>,
    Disposable {
        private static final long serialVersionUID = 4109457741734051389L;
        final SingleObserver<? super T> downstream;
        final Action onFinally;
        Disposable upstream;

        DoFinallyObserver(SingleObserver<? super T> actual, Action onFinally) {
            this.downstream = actual;
            this.onFinally = onFinally;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T t) {
            this.downstream.onSuccess(t);
            this.runFinally();
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
            this.runFinally();
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
            this.runFinally();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        void runFinally() {
            if (this.compareAndSet(0, 1)) {
                try {
                    this.onFinally.run();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    RxJavaPlugins.onError(ex);
                }
            }
        }
    }
}

