/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.single;

import shadow.io.reactivex.rxjava3.core.Single;
import shadow.io.reactivex.rxjava3.core.SingleObserver;
import shadow.io.reactivex.rxjava3.core.SingleSource;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.BiPredicate;

public final class SingleContains<T>
extends Single<Boolean> {
    final SingleSource<T> source;
    final Object value;
    final BiPredicate<Object, Object> comparer;

    public SingleContains(SingleSource<T> source, Object value, BiPredicate<Object, Object> comparer) {
        this.source = source;
        this.value = value;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super Boolean> observer) {
        this.source.subscribe(new ContainsSingleObserver(observer));
    }

    final class ContainsSingleObserver
    implements SingleObserver<T> {
        private final SingleObserver<? super Boolean> downstream;

        ContainsSingleObserver(SingleObserver<? super Boolean> observer) {
            this.downstream = observer;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.downstream.onSubscribe(d);
        }

        @Override
        public void onSuccess(T v) {
            boolean b;
            try {
                b = SingleContains.this.comparer.test(v, SingleContains.this.value);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            this.downstream.onSuccess((Boolean)b);
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }
    }
}

