/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.parallel;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.BiFunction;
import shadow.io.reactivex.rxjava3.functions.Supplier;
import shadow.io.reactivex.rxjava3.internal.subscribers.DeferredScalarSubscriber;
import shadow.io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import shadow.io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import shadow.io.reactivex.rxjava3.parallel.ParallelFlowable;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;
import shadow.org.reactivestreams.Subscriber;
import shadow.org.reactivestreams.Subscription;

public final class ParallelReduce<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<? extends T> source;
    final Supplier<R> initialSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public ParallelReduce(ParallelFlowable<? extends T> source, Supplier<R> initialSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers = RxJavaPlugins.onSubscribe(this, subscribers))) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            R initialValue;
            try {
                initialValue = Objects.requireNonNull(this.initialSupplier.get(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.reportError(subscribers, ex);
                return;
            }
            parents[i] = new ParallelReduceSubscriber<T, R>(subscribers[i], initialValue, this.reducer);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s : subscribers) {
            EmptySubscription.error(ex, s);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelReduceSubscriber<T, R>
    extends DeferredScalarSubscriber<T, R> {
        private static final long serialVersionUID = 8200530050639449080L;
        final BiFunction<R, ? super T, R> reducer;
        R accumulator;
        boolean done;

        ParallelReduceSubscriber(Subscriber<? super R> subscriber, R initialValue, BiFunction<R, ? super T, R> reducer) {
            super(subscriber);
            this.accumulator = initialValue;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                R v;
                try {
                    v = Objects.requireNonNull(this.reducer.apply(this.accumulator, t), "The reducer returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancel();
                    this.onError(ex);
                    return;
                }
                this.accumulator = v;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.accumulator = null;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                R a = this.accumulator;
                this.accumulator = null;
                this.complete(a);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

