/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import shadow.io.reactivex.rxjava3.core.Observable;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.core.Scheduler;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import shadow.io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import shadow.io.reactivex.rxjava3.internal.operators.observable.ObservableWindowSubscribeIntercept;
import shadow.io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import shadow.io.reactivex.rxjava3.operators.SimplePlainQueue;
import shadow.io.reactivex.rxjava3.subjects.UnicastSubject;

public final class ObservableWindowTimed<T>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final long timespan;
    final long timeskip;
    final TimeUnit unit;
    final Scheduler scheduler;
    final long maxSize;
    final int bufferSize;
    final boolean restartTimerOnMaxSize;

    public ObservableWindowTimed(Observable<T> source, long timespan, long timeskip, TimeUnit unit, Scheduler scheduler, long maxSize, int bufferSize, boolean restartTimerOnMaxSize) {
        super(source);
        this.timespan = timespan;
        this.timeskip = timeskip;
        this.unit = unit;
        this.scheduler = scheduler;
        this.maxSize = maxSize;
        this.bufferSize = bufferSize;
        this.restartTimerOnMaxSize = restartTimerOnMaxSize;
    }

    @Override
    protected void subscribeActual(Observer<? super Observable<T>> downstream) {
        if (this.timespan == this.timeskip) {
            if (this.maxSize == Long.MAX_VALUE) {
                this.source.subscribe(new WindowExactUnboundedObserver(downstream, this.timespan, this.unit, this.scheduler, this.bufferSize));
                return;
            }
            this.source.subscribe(new WindowExactBoundedObserver(downstream, this.timespan, this.unit, this.scheduler, this.bufferSize, this.maxSize, this.restartTimerOnMaxSize));
            return;
        }
        this.source.subscribe(new WindowSkipObserver(downstream, this.timespan, this.timeskip, this.unit, this.scheduler.createWorker(), this.bufferSize));
    }

    static final class WindowSkipObserver<T>
    extends AbstractWindowObserver<T>
    implements Runnable {
        private static final long serialVersionUID = -7852870764194095894L;
        final long timeskip;
        final Scheduler.Worker worker;
        final List<UnicastSubject<T>> windows;
        static final Object WINDOW_OPEN = new Object();
        static final Object WINDOW_CLOSE = new Object();

        WindowSkipObserver(Observer<? super Observable<T>> actual, long timespan, long timeskip, TimeUnit unit, Scheduler.Worker worker, int bufferSize) {
            super(actual, timespan, unit, bufferSize);
            this.timeskip = timeskip;
            this.worker = worker;
            this.windows = new LinkedList<UnicastSubject<T>>();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                this.emitted = 1L;
                this.windowCount.getAndIncrement();
                UnicastSubject window = UnicastSubject.create(this.bufferSize, this);
                this.windows.add(window);
                ObservableWindowSubscribeIntercept intercept = new ObservableWindowSubscribeIntercept(window);
                this.downstream.onNext(intercept);
                this.worker.schedule(new WindowBoundaryRunnable(this, false), this.timespan, this.unit);
                this.worker.schedulePeriodically(new WindowBoundaryRunnable(this, true), this.timeskip, this.timeskip, this.unit);
                if (intercept.tryAbandon()) {
                    window.onComplete();
                    this.windows.remove(window);
                }
            }
        }

        @Override
        void cleanupResources() {
            this.worker.dispose();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimplePlainQueue queue = this.queue;
            Observer downstream = this.downstream;
            List<UnicastSubject<T>> windows = this.windows;
            block0: while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    windows.clear();
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o = queue.poll();
                    boolean bl = isEmpty = o == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            for (UnicastSubject window : windows) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            for (UnicastSubject window : windows) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        UnicastSubject window;
                        if (o == WINDOW_OPEN) {
                            if (this.downstreamCancelled.get()) continue;
                            long emitted = this.emitted;
                            this.emitted = ++emitted;
                            this.windowCount.getAndIncrement();
                            window = UnicastSubject.create(this.bufferSize, this);
                            windows.add(window);
                            ObservableWindowSubscribeIntercept<T> intercept = new ObservableWindowSubscribeIntercept<T>(window);
                            downstream.onNext(intercept);
                            this.worker.schedule(new WindowBoundaryRunnable(this, false), this.timespan, this.unit);
                            if (!intercept.tryAbandon()) continue;
                            window.onComplete();
                            continue;
                        }
                        if (o == WINDOW_CLOSE) {
                            if (windows.isEmpty()) continue;
                            windows.remove(0).onComplete();
                            continue;
                        }
                        Object item = o;
                        Iterator<UnicastSubject<T>> iterator = windows.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block0;
                            window = iterator.next();
                            window.onNext(item);
                        }
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void run() {
            this.windowDone();
        }

        void boundary(boolean isOpen) {
            this.queue.offer(isOpen ? WINDOW_OPEN : WINDOW_CLOSE);
            this.drain();
        }

        static final class WindowBoundaryRunnable
        implements Runnable {
            final WindowSkipObserver<?> parent;
            final boolean isOpen;

            WindowBoundaryRunnable(WindowSkipObserver<?> parent, boolean isOpen) {
                this.parent = parent;
                this.isOpen = isOpen;
            }

            @Override
            public void run() {
                this.parent.boundary(this.isOpen);
            }
        }
    }

    static final class WindowExactBoundedObserver<T>
    extends AbstractWindowObserver<T>
    implements Runnable {
        private static final long serialVersionUID = -6130475889925953722L;
        final Scheduler scheduler;
        final boolean restartTimerOnMaxSize;
        final long maxSize;
        final Scheduler.Worker worker;
        long count;
        UnicastSubject<T> window;
        final SequentialDisposable timer;

        WindowExactBoundedObserver(Observer<? super Observable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize, long maxSize, boolean restartTimerOnMaxSize) {
            super(actual, timespan, unit, bufferSize);
            this.scheduler = scheduler;
            this.maxSize = maxSize;
            this.restartTimerOnMaxSize = restartTimerOnMaxSize;
            this.worker = restartTimerOnMaxSize ? scheduler.createWorker() : null;
            this.timer = new SequentialDisposable();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                this.emitted = 1L;
                this.windowCount.getAndIncrement();
                this.window = UnicastSubject.create(this.bufferSize, this);
                ObservableWindowSubscribeIntercept<T> intercept = new ObservableWindowSubscribeIntercept<T>(this.window);
                this.downstream.onNext(intercept);
                WindowBoundaryRunnable boundaryTask = new WindowBoundaryRunnable(this, 1L);
                if (this.restartTimerOnMaxSize) {
                    this.timer.replace(this.worker.schedulePeriodically(boundaryTask, this.timespan, this.timespan, this.unit));
                } else {
                    this.timer.replace(this.scheduler.schedulePeriodicallyDirect(boundaryTask, this.timespan, this.timespan, this.unit));
                }
                if (intercept.tryAbandon()) {
                    this.window.onComplete();
                }
            }
        }

        @Override
        public void run() {
            this.windowDone();
        }

        @Override
        void cleanupResources() {
            this.timer.dispose();
            Scheduler.Worker w = this.worker;
            if (w != null) {
                w.dispose();
            }
        }

        void boundary(WindowBoundaryRunnable sender) {
            this.queue.offer(sender);
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            SimplePlainQueue queue = this.queue;
            Observer downstream = this.downstream;
            UnicastSubject window = this.window;
            while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    window = null;
                    this.window = null;
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o = queue.poll();
                    boolean bl = isEmpty = o == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            if (window != null) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            if (window != null) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o instanceof WindowBoundaryRunnable) {
                            WindowBoundaryRunnable boundary = (WindowBoundaryRunnable)o;
                            if (boundary.index != this.emitted && this.restartTimerOnMaxSize) continue;
                            this.count = 0L;
                            window = this.createNewWindow(window);
                            continue;
                        }
                        if (window == null) continue;
                        Object item = o;
                        window.onNext(item);
                        long count = this.count + 1L;
                        if (count == this.maxSize) {
                            this.count = 0L;
                            window = this.createNewWindow(window);
                            continue;
                        }
                        this.count = count;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        UnicastSubject<T> createNewWindow(UnicastSubject<T> window) {
            if (window != null) {
                window.onComplete();
                window = null;
            }
            if (this.downstreamCancelled.get()) {
                this.cleanupResources();
            } else {
                long emitted = this.emitted;
                this.emitted = ++emitted;
                this.windowCount.getAndIncrement();
                window = UnicastSubject.create(this.bufferSize, this);
                this.window = window;
                ObservableWindowSubscribeIntercept<T> intercept = new ObservableWindowSubscribeIntercept<T>(window);
                this.downstream.onNext(intercept);
                if (this.restartTimerOnMaxSize) {
                    this.timer.update(this.worker.schedulePeriodically(new WindowBoundaryRunnable(this, emitted), this.timespan, this.timespan, this.unit));
                }
                if (intercept.tryAbandon()) {
                    window.onComplete();
                }
            }
            return window;
        }

        static final class WindowBoundaryRunnable
        implements Runnable {
            final WindowExactBoundedObserver<?> parent;
            final long index;

            WindowBoundaryRunnable(WindowExactBoundedObserver<?> parent, long index) {
                this.parent = parent;
                this.index = index;
            }

            @Override
            public void run() {
                this.parent.boundary(this);
            }
        }
    }

    static final class WindowExactUnboundedObserver<T>
    extends AbstractWindowObserver<T>
    implements Runnable {
        private static final long serialVersionUID = 1155822639622580836L;
        final Scheduler scheduler;
        UnicastSubject<T> window;
        final SequentialDisposable timer;
        static final Object NEXT_WINDOW = new Object();
        final Runnable windowRunnable;

        WindowExactUnboundedObserver(Observer<? super Observable<T>> actual, long timespan, TimeUnit unit, Scheduler scheduler, int bufferSize) {
            super(actual, timespan, unit, bufferSize);
            this.scheduler = scheduler;
            this.timer = new SequentialDisposable();
            this.windowRunnable = new WindowRunnable();
        }

        @Override
        void createFirstWindow() {
            if (!this.downstreamCancelled.get()) {
                this.windowCount.getAndIncrement();
                this.window = UnicastSubject.create(this.bufferSize, this.windowRunnable);
                this.emitted = 1L;
                ObservableWindowSubscribeIntercept<T> intercept = new ObservableWindowSubscribeIntercept<T>(this.window);
                this.downstream.onNext(intercept);
                this.timer.replace(this.scheduler.schedulePeriodicallyDirect(this, this.timespan, this.timespan, this.unit));
                if (intercept.tryAbandon()) {
                    this.window.onComplete();
                }
            }
        }

        @Override
        public void run() {
            this.queue.offer(NEXT_WINDOW);
            this.drain();
        }

        @Override
        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            SimplePlainQueue queue = this.queue;
            Observer downstream = this.downstream;
            UnicastSubject window = this.window;
            int missed = 1;
            while (true) {
                if (this.upstreamCancelled) {
                    queue.clear();
                    window = null;
                    this.window = null;
                } else {
                    boolean isEmpty;
                    boolean isDone = this.done;
                    Object o = queue.poll();
                    boolean bl = isEmpty = o == null;
                    if (isDone && isEmpty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            if (window != null) {
                                window.onError(ex);
                            }
                            downstream.onError(ex);
                        } else {
                            if (window != null) {
                                window.onComplete();
                            }
                            downstream.onComplete();
                        }
                        this.cleanupResources();
                        this.upstreamCancelled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o == NEXT_WINDOW) {
                            if (window != null) {
                                window.onComplete();
                                window = null;
                                this.window = null;
                            }
                            if (this.downstreamCancelled.get()) {
                                this.timer.dispose();
                                continue;
                            }
                            ++this.emitted;
                            this.windowCount.getAndIncrement();
                            window = UnicastSubject.create(this.bufferSize, this.windowRunnable);
                            this.window = window;
                            ObservableWindowSubscribeIntercept<T> intercept = new ObservableWindowSubscribeIntercept<T>(window);
                            downstream.onNext(intercept);
                            if (!intercept.tryAbandon()) continue;
                            window.onComplete();
                            continue;
                        }
                        if (window == null) continue;
                        Object item = o;
                        window.onNext(item);
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        void cleanupResources() {
            this.timer.dispose();
        }

        final class WindowRunnable
        implements Runnable {
            WindowRunnable() {
            }

            @Override
            public void run() {
                WindowExactUnboundedObserver.this.windowDone();
            }
        }
    }

    static abstract class AbstractWindowObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 5724293814035355511L;
        final Observer<? super Observable<T>> downstream;
        final SimplePlainQueue<Object> queue;
        final long timespan;
        final TimeUnit unit;
        final int bufferSize;
        long emitted;
        volatile boolean done;
        Throwable error;
        Disposable upstream;
        final AtomicBoolean downstreamCancelled;
        volatile boolean upstreamCancelled;
        final AtomicInteger windowCount;

        AbstractWindowObserver(Observer<? super Observable<T>> downstream, long timespan, TimeUnit unit, int bufferSize) {
            this.downstream = downstream;
            this.queue = new MpscLinkedQueue<Object>();
            this.timespan = timespan;
            this.unit = unit;
            this.bufferSize = bufferSize;
            this.downstreamCancelled = new AtomicBoolean();
            this.windowCount = new AtomicInteger(1);
        }

        @Override
        public final void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                this.createFirstWindow();
            }
        }

        abstract void createFirstWindow();

        @Override
        public final void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public final void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.drain();
        }

        @Override
        public final void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public final void dispose() {
            if (this.downstreamCancelled.compareAndSet(false, true)) {
                this.windowDone();
            }
        }

        @Override
        public final boolean isDisposed() {
            return this.downstreamCancelled.get();
        }

        final void windowDone() {
            if (this.windowCount.decrementAndGet() == 0) {
                this.cleanupResources();
                this.upstream.dispose();
                this.upstreamCancelled = true;
                this.drain();
            }
        }

        abstract void cleanupResources();

        abstract void drain();
    }
}

