/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import shadow.io.reactivex.rxjava3.core.Observable;
import shadow.io.reactivex.rxjava3.core.ObservableSource;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.disposables.CompositeDisposable;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import shadow.io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import shadow.io.reactivex.rxjava3.internal.util.AtomicThrowable;
import shadow.io.reactivex.rxjava3.internal.util.ExceptionHelper;
import shadow.io.reactivex.rxjava3.operators.SimplePlainQueue;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;
import shadow.io.reactivex.rxjava3.subjects.UnicastSubject;

public final class ObservableWindowBoundarySelector<T, B, V>
extends AbstractObservableWithUpstream<T, Observable<T>> {
    final ObservableSource<B> open;
    final Function<? super B, ? extends ObservableSource<V>> closingIndicator;
    final int bufferSize;

    public ObservableWindowBoundarySelector(ObservableSource<T> source, ObservableSource<B> open, Function<? super B, ? extends ObservableSource<V>> closingIndicator, int bufferSize) {
        super(source);
        this.open = open;
        this.closingIndicator = closingIndicator;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super Observable<T>> t) {
        this.source.subscribe(new WindowBoundaryMainObserver(t, this.open, this.closingIndicator, this.bufferSize));
    }

    static final class WindowBoundaryMainObserver<T, B, V>
    extends AtomicInteger
    implements Observer<T>,
    Disposable,
    Runnable {
        private static final long serialVersionUID = 8646217640096099753L;
        final Observer<? super Observable<T>> downstream;
        final ObservableSource<B> open;
        final Function<? super B, ? extends ObservableSource<V>> closingIndicator;
        final int bufferSize;
        final CompositeDisposable resources;
        final WindowStartObserver<B> startObserver;
        final List<UnicastSubject<T>> windows;
        final SimplePlainQueue<Object> queue;
        final AtomicLong windowCount;
        final AtomicBoolean downstreamDisposed;
        final AtomicLong requested;
        long emitted;
        volatile boolean upstreamCanceled;
        volatile boolean upstreamDone;
        volatile boolean openDone;
        final AtomicThrowable error;
        Disposable upstream;

        WindowBoundaryMainObserver(Observer<? super Observable<T>> downstream, ObservableSource<B> open, Function<? super B, ? extends ObservableSource<V>> closingIndicator, int bufferSize) {
            this.downstream = downstream;
            this.queue = new MpscLinkedQueue<Object>();
            this.open = open;
            this.closingIndicator = closingIndicator;
            this.bufferSize = bufferSize;
            this.resources = new CompositeDisposable();
            this.windows = new ArrayList<UnicastSubject<T>>();
            this.windowCount = new AtomicLong(1L);
            this.downstreamDisposed = new AtomicBoolean();
            this.error = new AtomicThrowable();
            this.startObserver = new WindowStartObserver(this);
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
                this.open.subscribe(this.startObserver);
            }
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.startObserver.dispose();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.startObserver.dispose();
            this.resources.dispose();
            this.upstreamDone = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (this.downstreamDisposed.compareAndSet(false, true)) {
                if (this.windowCount.decrementAndGet() == 0L) {
                    this.upstream.dispose();
                    this.startObserver.dispose();
                    this.resources.dispose();
                    this.error.tryTerminateAndReport();
                    this.upstreamCanceled = true;
                    this.drain();
                } else {
                    this.startObserver.dispose();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.downstreamDisposed.get();
        }

        @Override
        public void run() {
            if (this.windowCount.decrementAndGet() == 0L) {
                this.upstream.dispose();
                this.startObserver.dispose();
                this.resources.dispose();
                this.error.tryTerminateAndReport();
                this.upstreamCanceled = true;
                this.drain();
            }
        }

        void open(B startValue) {
            this.queue.offer(new WindowStartItem<B>(startValue));
            this.drain();
        }

        void openError(Throwable t) {
            this.upstream.dispose();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void openComplete() {
            this.openDone = true;
            this.drain();
        }

        void close(WindowEndObserverIntercept<T, V> what) {
            this.queue.offer(what);
            this.drain();
        }

        void closeError(Throwable t) {
            this.upstream.dispose();
            this.startObserver.dispose();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer downstream = this.downstream;
            SimplePlainQueue<Object> queue = this.queue;
            List<UnicastSubject<T>> windows = this.windows;
            block2: while (true) {
                if (this.upstreamCanceled) {
                    queue.clear();
                    windows.clear();
                } else {
                    boolean isEmpty;
                    boolean isDone = this.upstreamDone;
                    Object o = queue.poll();
                    boolean bl = isEmpty = o == null;
                    if (isDone && (isEmpty || this.error.get() != null)) {
                        this.terminateDownstream(downstream);
                        this.upstreamCanceled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o instanceof WindowStartItem) {
                            ObservableSource<V> endSource;
                            if (this.downstreamDisposed.get()) continue;
                            Object startItem = ((WindowStartItem)o).item;
                            try {
                                endSource = Objects.requireNonNull(this.closingIndicator.apply(startItem), "The closingIndicator returned a null ObservableSource");
                            }
                            catch (Throwable ex) {
                                Exceptions.throwIfFatal(ex);
                                this.upstream.dispose();
                                this.startObserver.dispose();
                                this.resources.dispose();
                                Exceptions.throwIfFatal(ex);
                                this.error.tryAddThrowableOrReport(ex);
                                this.upstreamDone = true;
                                continue;
                            }
                            this.windowCount.getAndIncrement();
                            UnicastSubject newWindow = UnicastSubject.create(this.bufferSize, this);
                            WindowEndObserverIntercept endObserver = new WindowEndObserverIntercept(this, newWindow);
                            downstream.onNext(endObserver);
                            if (endObserver.tryAbandon()) {
                                newWindow.onComplete();
                                continue;
                            }
                            windows.add(newWindow);
                            this.resources.add(endObserver);
                            endSource.subscribe(endObserver);
                            continue;
                        }
                        if (o instanceof WindowEndObserverIntercept) {
                            UnicastSubject w = ((WindowEndObserverIntercept)o).window;
                            windows.remove(w);
                            this.resources.delete((Disposable)o);
                            w.onComplete();
                            continue;
                        }
                        Object item = o;
                        Iterator<UnicastSubject<T>> iterator = windows.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            UnicastSubject<Object> w = iterator.next();
                            w.onNext(item);
                        }
                    }
                    if (this.openDone && windows.size() == 0) {
                        this.upstream.dispose();
                        this.startObserver.dispose();
                        this.resources.dispose();
                        this.terminateDownstream(downstream);
                        this.upstreamCanceled = true;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void terminateDownstream(Observer<?> downstream) {
            Throwable ex = this.error.terminate();
            if (ex == null) {
                for (UnicastSubject<T> w : this.windows) {
                    w.onComplete();
                }
                downstream.onComplete();
            } else if (ex != ExceptionHelper.TERMINATED) {
                for (UnicastSubject<T> w : this.windows) {
                    w.onError(ex);
                }
                downstream.onError(ex);
            }
        }

        static final class WindowEndObserverIntercept<T, V>
        extends Observable<T>
        implements Observer<V>,
        Disposable {
            final WindowBoundaryMainObserver<T, ?, V> parent;
            final UnicastSubject<T> window;
            final AtomicReference<Disposable> upstream;
            final AtomicBoolean once;

            WindowEndObserverIntercept(WindowBoundaryMainObserver<T, ?, V> parent, UnicastSubject<T> window) {
                this.parent = parent;
                this.window = window;
                this.upstream = new AtomicReference();
                this.once = new AtomicBoolean();
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this.upstream, d);
            }

            @Override
            public void onNext(V t) {
                if (DisposableHelper.dispose(this.upstream)) {
                    this.parent.close(this);
                }
            }

            @Override
            public void onError(Throwable t) {
                if (this.isDisposed()) {
                    RxJavaPlugins.onError(t);
                } else {
                    this.parent.closeError(t);
                }
            }

            @Override
            public void onComplete() {
                this.parent.close(this);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this.upstream);
            }

            @Override
            public boolean isDisposed() {
                return this.upstream.get() == DisposableHelper.DISPOSED;
            }

            @Override
            protected void subscribeActual(Observer<? super T> o) {
                this.window.subscribe(o);
                this.once.set(true);
            }

            boolean tryAbandon() {
                return !this.once.get() && this.once.compareAndSet(false, true);
            }
        }

        static final class WindowStartObserver<B>
        extends AtomicReference<Disposable>
        implements Observer<B> {
            private static final long serialVersionUID = -3326496781427702834L;
            final WindowBoundaryMainObserver<?, B, ?> parent;

            WindowStartObserver(WindowBoundaryMainObserver<?, B, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onNext(B t) {
                this.parent.open(t);
            }

            @Override
            public void onError(Throwable t) {
                this.parent.openError(t);
            }

            @Override
            public void onComplete() {
                this.parent.openComplete();
            }

            void dispose() {
                DisposableHelper.dispose(this);
            }
        }

        static final class WindowStartItem<B> {
            final B item;

            WindowStartItem(B item) {
                this.item = item;
            }
        }
    }
}

