/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import java.util.concurrent.atomic.AtomicInteger;
import shadow.io.reactivex.rxjava3.core.Observable;
import shadow.io.reactivex.rxjava3.core.ObservableSource;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import shadow.io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableRepeat<T>
extends AbstractObservableWithUpstream<T, T> {
    final long count;

    public ObservableRepeat(Observable<T> source, long count) {
        super(source);
        this.count = count;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        SequentialDisposable sd = new SequentialDisposable();
        observer.onSubscribe(sd);
        RepeatObserver<T> rs = new RepeatObserver<T>(observer, this.count != Long.MAX_VALUE ? this.count - 1L : Long.MAX_VALUE, sd, this.source);
        rs.subscribeNext();
    }

    static final class RepeatObserver<T>
    extends AtomicInteger
    implements Observer<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Observer<? super T> downstream;
        final SequentialDisposable sd;
        final ObservableSource<? extends T> source;
        long remaining;

        RepeatObserver(Observer<? super T> actual, long count, SequentialDisposable sd, ObservableSource<? extends T> source) {
            this.downstream = actual;
            this.sd = sd;
            this.source = source;
            this.remaining = count;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.sd.replace(d);
        }

        @Override
        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r != 0L) {
                this.subscribeNext();
            } else {
                this.downstream.onComplete();
            }
        }

        void subscribeNext() {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                int missed = 1;
                do {
                    if (this.sd.isDisposed()) {
                        return;
                    }
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

