/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.core.Maybe;
import shadow.io.reactivex.rxjava3.core.MaybeObserver;
import shadow.io.reactivex.rxjava3.core.ObservableSource;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.BiFunction;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableReduceMaybe<T>
extends Maybe<T> {
    final ObservableSource<T> source;
    final BiFunction<T, T, T> reducer;

    public ObservableReduceMaybe(ObservableSource<T> source, BiFunction<T, T, T> reducer) {
        this.source = source;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        this.source.subscribe(new ReduceObserver<T>(observer, this.reducer));
    }

    static final class ReduceObserver<T>
    implements Observer<T>,
    Disposable {
        final MaybeObserver<? super T> downstream;
        final BiFunction<T, T, T> reducer;
        boolean done;
        T value;
        Disposable upstream;

        ReduceObserver(MaybeObserver<? super T> observer, BiFunction<T, T, T> reducer) {
            this.downstream = observer;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            if (!this.done) {
                T v = this.value;
                if (v == null) {
                    this.value = value;
                } else {
                    try {
                        this.value = Objects.requireNonNull(this.reducer.apply(v, value), "The reducer returned a null value");
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.upstream.dispose();
                        this.onError(ex);
                    }
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError(e);
                return;
            }
            this.done = true;
            this.value = null;
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            T v = this.value;
            this.value = null;
            if (v != null) {
                this.downstream.onSuccess(v);
            } else {
                this.downstream.onComplete();
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }
    }
}

