/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.annotations.Nullable;
import shadow.io.reactivex.rxjava3.core.ObservableSource;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.observers.BasicFuseableObserver;
import shadow.io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends U> function;

    public ObservableMap(ObservableSource<T> source, Function<? super T, ? extends U> function) {
        super(source);
        this.function = function;
    }

    @Override
    public void subscribeActual(Observer<? super U> t) {
        this.source.subscribe(new MapObserver<T, U>(t, this.function));
    }

    static final class MapObserver<T, U>
    extends BasicFuseableObserver<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapObserver(Observer<? super U> actual, Function<? super T, ? extends U> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v = Objects.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.downstream.onNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Throwable {
            Object t = this.qd.poll();
            return t != null ? (U)Objects.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.") : null;
        }
    }
}

