/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import shadow.io.reactivex.rxjava3.core.Emitter;
import shadow.io.reactivex.rxjava3.core.Observable;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.BiFunction;
import shadow.io.reactivex.rxjava3.functions.Consumer;
import shadow.io.reactivex.rxjava3.functions.Supplier;
import shadow.io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import shadow.io.reactivex.rxjava3.internal.util.ExceptionHelper;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableGenerate<T, S>
extends Observable<T> {
    final Supplier<S> stateSupplier;
    final BiFunction<S, Emitter<T>, S> generator;
    final Consumer<? super S> disposeState;

    public ObservableGenerate(Supplier<S> stateSupplier, BiFunction<S, Emitter<T>, S> generator, Consumer<? super S> disposeState) {
        this.stateSupplier = stateSupplier;
        this.generator = generator;
        this.disposeState = disposeState;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        S state;
        try {
            state = this.stateSupplier.get();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, observer);
            return;
        }
        GeneratorDisposable<T, S> gd = new GeneratorDisposable<T, S>(observer, this.generator, this.disposeState, state);
        observer.onSubscribe(gd);
        gd.run();
    }

    static final class GeneratorDisposable<T, S>
    implements Emitter<T>,
    Disposable {
        final Observer<? super T> downstream;
        final BiFunction<S, ? super Emitter<T>, S> generator;
        final Consumer<? super S> disposeState;
        S state;
        volatile boolean cancelled;
        boolean terminate;
        boolean hasNext;

        GeneratorDisposable(Observer<? super T> actual, BiFunction<S, ? super Emitter<T>, S> generator, Consumer<? super S> disposeState, S initialState) {
            this.downstream = actual;
            this.generator = generator;
            this.disposeState = disposeState;
            this.state = initialState;
        }

        public void run() {
            S s = this.state;
            if (this.cancelled) {
                this.state = null;
                this.dispose(s);
                return;
            }
            BiFunction<S, Emitter<T>, S> f = this.generator;
            do {
                if (this.cancelled) {
                    this.state = null;
                    this.dispose(s);
                    return;
                }
                this.hasNext = false;
                try {
                    s = f.apply(s, this);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.state = null;
                    this.cancelled = true;
                    this.onError(ex);
                    this.dispose(s);
                    return;
                }
            } while (!this.terminate);
            this.cancelled = true;
            this.state = null;
            this.dispose(s);
        }

        private void dispose(S s) {
            try {
                this.disposeState.accept(s);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }

        @Override
        public void dispose() {
            this.cancelled = true;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void onNext(T t) {
            if (!this.terminate) {
                if (this.hasNext) {
                    this.onError(new IllegalStateException("onNext already called in this generate turn"));
                } else if (t == null) {
                    this.onError(ExceptionHelper.createNullPointerException("onNext called with a null value."));
                } else {
                    this.hasNext = true;
                    this.downstream.onNext(t);
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.terminate) {
                RxJavaPlugins.onError(t);
            } else {
                if (t == null) {
                    t = ExceptionHelper.createNullPointerException("onError called with a null Throwable.");
                }
                this.terminate = true;
                this.downstream.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (!this.terminate) {
                this.terminate = true;
                this.downstream.onComplete();
            }
        }
    }
}

