/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import shadow.io.reactivex.rxjava3.core.Observable;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;
import shadow.io.reactivex.rxjava3.internal.util.ExceptionHelper;

public final class ObservableFromFuture<T>
extends Observable<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public ObservableFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        DeferredScalarDisposable<T> d = new DeferredScalarDisposable<T>(observer);
        observer.onSubscribe(d);
        if (!d.isDisposed()) {
            T v;
            try {
                v = ExceptionHelper.nullCheck(this.unit != null ? this.future.get(this.timeout, this.unit) : this.future.get(), "Future returned a null value.");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (!d.isDisposed()) {
                    observer.onError(ex);
                }
                return;
            }
            d.complete(v);
        }
    }
}

