/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import java.util.NoSuchElementException;
import shadow.io.reactivex.rxjava3.core.ObservableSource;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableElementAt<T>
extends AbstractObservableWithUpstream<T, T> {
    final long index;
    final T defaultValue;
    final boolean errorOnFewer;

    public ObservableElementAt(ObservableSource<T> source, long index, T defaultValue, boolean errorOnFewer) {
        super(source);
        this.index = index;
        this.defaultValue = defaultValue;
        this.errorOnFewer = errorOnFewer;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new ElementAtObserver<T>(t, this.index, this.defaultValue, this.errorOnFewer));
    }

    static final class ElementAtObserver<T>
    implements Observer<T>,
    Disposable {
        final Observer<? super T> downstream;
        final long index;
        final T defaultValue;
        final boolean errorOnFewer;
        Disposable upstream;
        long count;
        boolean done;

        ElementAtObserver(Observer<? super T> actual, long index, T defaultValue, boolean errorOnFewer) {
            this.downstream = actual;
            this.index = index;
            this.defaultValue = defaultValue;
            this.errorOnFewer = errorOnFewer;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            long c = this.count;
            if (c == this.index) {
                this.done = true;
                this.upstream.dispose();
                this.downstream.onNext(t);
                this.downstream.onComplete();
                return;
            }
            this.count = c + 1L;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                T v = this.defaultValue;
                if (v == null && this.errorOnFewer) {
                    this.downstream.onError(new NoSuchElementException());
                } else {
                    if (v != null) {
                        this.downstream.onNext(v);
                    }
                    this.downstream.onComplete();
                }
            }
        }
    }
}

