/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.observable;

import shadow.io.reactivex.rxjava3.annotations.Nullable;
import shadow.io.reactivex.rxjava3.core.ObservableSource;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.functions.BiPredicate;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.observers.BasicFuseableObserver;
import shadow.io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;

public final class ObservableDistinctUntilChanged<T, K>
extends AbstractObservableWithUpstream<T, T> {
    final Function<? super T, K> keySelector;
    final BiPredicate<? super K, ? super K> comparer;

    public ObservableDistinctUntilChanged(ObservableSource<T> source, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
        super(source);
        this.keySelector = keySelector;
        this.comparer = comparer;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(new DistinctUntilChangedObserver<T, K>(observer, this.keySelector, this.comparer));
    }

    static final class DistinctUntilChangedObserver<T, K>
    extends BasicFuseableObserver<T, T> {
        final Function<? super T, K> keySelector;
        final BiPredicate<? super K, ? super K> comparer;
        K last;
        boolean hasValue;

        DistinctUntilChangedObserver(Observer<? super T> actual, Function<? super T, K> keySelector, BiPredicate<? super K, ? super K> comparer) {
            super(actual);
            this.keySelector = keySelector;
            this.comparer = comparer;
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(t);
                return;
            }
            try {
                K key = this.keySelector.apply(t);
                if (this.hasValue) {
                    boolean equal = this.comparer.test(this.last, key);
                    this.last = key;
                    if (equal) {
                        return;
                    }
                } else {
                    this.hasValue = true;
                    this.last = key;
                }
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.downstream.onNext(t);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v;
            while ((v = this.qd.poll()) != null) {
                K key = this.keySelector.apply(v);
                if (!this.hasValue) {
                    this.hasValue = true;
                    this.last = key;
                    return v;
                }
                if (!this.comparer.test(this.last, key)) {
                    this.last = key;
                    return v;
                }
                this.last = key;
            }
            return null;
        }
    }
}

