/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.maybe;

import shadow.io.reactivex.rxjava3.core.MaybeObserver;
import shadow.io.reactivex.rxjava3.core.MaybeSource;
import shadow.io.reactivex.rxjava3.core.Observable;
import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.internal.fuseable.HasUpstreamMaybeSource;
import shadow.io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;

public final class MaybeToObservable<T>
extends Observable<T>
implements HasUpstreamMaybeSource<T> {
    final MaybeSource<T> source;

    public MaybeToObservable(MaybeSource<T> source) {
        this.source = source;
    }

    @Override
    public MaybeSource<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.source.subscribe(MaybeToObservable.create(observer));
    }

    public static <T> MaybeObserver<T> create(Observer<? super T> downstream) {
        return new MaybeToObservableObserver<T>(downstream);
    }

    static final class MaybeToObservableObserver<T>
    extends DeferredScalarDisposable<T>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = 7603343402964826922L;
        Disposable upstream;

        MaybeToObservableObserver(Observer<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T value) {
            this.complete(value);
        }

        @Override
        public void onError(Throwable e) {
            this.error(e);
        }

        @Override
        public void onComplete() {
            this.complete();
        }

        @Override
        public void dispose() {
            super.dispose();
            this.upstream.dispose();
        }
    }
}

