/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.maybe;

import shadow.io.reactivex.rxjava3.core.Maybe;
import shadow.io.reactivex.rxjava3.core.MaybeObserver;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Supplier;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class MaybeFromRunnable<T>
extends Maybe<T>
implements Supplier<T> {
    final Runnable runnable;

    public MaybeFromRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super T> observer) {
        Disposable d = Disposable.empty();
        observer.onSubscribe(d);
        if (!d.isDisposed()) {
            try {
                this.runnable.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (!d.isDisposed()) {
                    observer.onError(ex);
                } else {
                    RxJavaPlugins.onError(ex);
                }
                return;
            }
            if (!d.isDisposed()) {
                observer.onComplete();
            }
        }
    }

    @Override
    public T get() {
        this.runnable.run();
        return null;
    }
}

