/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.maybe;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.core.Maybe;
import shadow.io.reactivex.rxjava3.core.MaybeObserver;
import shadow.io.reactivex.rxjava3.core.Notification;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.internal.operators.maybe.AbstractMaybeWithUpstream;

public final class MaybeDematerialize<T, R>
extends AbstractMaybeWithUpstream<T, R> {
    final Function<? super T, Notification<R>> selector;

    public MaybeDematerialize(Maybe<T> source, Function<? super T, Notification<R>> selector) {
        super(source);
        this.selector = selector;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        this.source.subscribe(new DematerializeObserver<T, R>(observer, this.selector));
    }

    static final class DematerializeObserver<T, R>
    implements MaybeObserver<T>,
    Disposable {
        final MaybeObserver<? super R> downstream;
        final Function<? super T, Notification<R>> selector;
        Disposable upstream;

        DematerializeObserver(MaybeObserver<? super R> downstream, Function<? super T, Notification<R>> selector) {
            this.downstream = downstream;
            this.selector = selector;
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onSuccess(T t) {
            Notification<R> notification;
            try {
                notification = Objects.requireNonNull(this.selector.apply(t), "The selector returned a null Notification");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            if (notification.isOnNext()) {
                this.downstream.onSuccess(notification.getValue());
            } else if (notification.isOnComplete()) {
                this.downstream.onComplete();
            } else {
                this.downstream.onError(notification.getError());
            }
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

