/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.core.FlowableSubscriber;
import shadow.io.reactivex.rxjava3.disposables.CompositeDisposable;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.FlowableWindowTimed;
import shadow.io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import shadow.io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import shadow.io.reactivex.rxjava3.internal.util.AtomicThrowable;
import shadow.io.reactivex.rxjava3.internal.util.BackpressureHelper;
import shadow.io.reactivex.rxjava3.internal.util.ExceptionHelper;
import shadow.io.reactivex.rxjava3.operators.SimplePlainQueue;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;
import shadow.io.reactivex.rxjava3.processors.UnicastProcessor;
import shadow.org.reactivestreams.Publisher;
import shadow.org.reactivestreams.Subscriber;
import shadow.org.reactivestreams.Subscription;

public final class FlowableWindowBoundarySelector<T, B, V>
extends AbstractFlowableWithUpstream<T, Flowable<T>> {
    final Publisher<B> open;
    final Function<? super B, ? extends Publisher<V>> closingIndicator;
    final int bufferSize;

    public FlowableWindowBoundarySelector(Flowable<T> source, Publisher<B> open, Function<? super B, ? extends Publisher<V>> closingIndicator, int bufferSize) {
        super(source);
        this.open = open;
        this.closingIndicator = closingIndicator;
        this.bufferSize = bufferSize;
    }

    @Override
    protected void subscribeActual(Subscriber<? super Flowable<T>> s) {
        this.source.subscribe(new WindowBoundaryMainSubscriber(s, this.open, this.closingIndicator, this.bufferSize));
    }

    static final class WindowBoundaryMainSubscriber<T, B, V>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = 8646217640096099753L;
        final Subscriber<? super Flowable<T>> downstream;
        final Publisher<B> open;
        final Function<? super B, ? extends Publisher<V>> closingIndicator;
        final int bufferSize;
        final CompositeDisposable resources;
        final WindowStartSubscriber<B> startSubscriber;
        final List<UnicastProcessor<T>> windows;
        final SimplePlainQueue<Object> queue;
        final AtomicLong windowCount;
        final AtomicBoolean downstreamCancelled;
        final AtomicLong requested;
        long emitted;
        volatile boolean upstreamCanceled;
        volatile boolean upstreamDone;
        volatile boolean openDone;
        final AtomicThrowable error;
        Subscription upstream;

        WindowBoundaryMainSubscriber(Subscriber<? super Flowable<T>> actual, Publisher<B> open, Function<? super B, ? extends Publisher<V>> closingIndicator, int bufferSize) {
            this.downstream = actual;
            this.queue = new MpscLinkedQueue<Object>();
            this.open = open;
            this.closingIndicator = closingIndicator;
            this.bufferSize = bufferSize;
            this.resources = new CompositeDisposable();
            this.windows = new ArrayList<UnicastProcessor<T>>();
            this.windowCount = new AtomicLong(1L);
            this.downstreamCancelled = new AtomicBoolean();
            this.error = new AtomicThrowable();
            this.startSubscriber = new WindowStartSubscriber(this);
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                this.open.subscribe(this.startSubscriber);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.startSubscriber.cancel();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.startSubscriber.cancel();
            this.resources.dispose();
            this.upstreamDone = true;
            this.drain();
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        @Override
        public void cancel() {
            if (this.downstreamCancelled.compareAndSet(false, true)) {
                if (this.windowCount.decrementAndGet() == 0L) {
                    this.upstream.cancel();
                    this.startSubscriber.cancel();
                    this.resources.dispose();
                    this.error.tryTerminateAndReport();
                    this.upstreamCanceled = true;
                    this.drain();
                } else {
                    this.startSubscriber.cancel();
                }
            }
        }

        @Override
        public void run() {
            if (this.windowCount.decrementAndGet() == 0L) {
                this.upstream.cancel();
                this.startSubscriber.cancel();
                this.resources.dispose();
                this.error.tryTerminateAndReport();
                this.upstreamCanceled = true;
                this.drain();
            }
        }

        void open(B startValue) {
            this.queue.offer(new WindowStartItem<B>(startValue));
            this.drain();
        }

        void openError(Throwable t) {
            this.upstream.cancel();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void openComplete() {
            this.openDone = true;
            this.drain();
        }

        void close(WindowEndSubscriberIntercept<T, V> what) {
            this.queue.offer(what);
            this.drain();
        }

        void closeError(Throwable t) {
            this.upstream.cancel();
            this.startSubscriber.cancel();
            this.resources.dispose();
            if (this.error.tryAddThrowableOrReport(t)) {
                this.upstreamDone = true;
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber downstream = this.downstream;
            SimplePlainQueue<Object> queue = this.queue;
            List<UnicastProcessor<T>> windows = this.windows;
            block2: while (true) {
                if (this.upstreamCanceled) {
                    queue.clear();
                    windows.clear();
                } else {
                    boolean isEmpty;
                    boolean isDone = this.upstreamDone;
                    Object o = queue.poll();
                    boolean bl = isEmpty = o == null;
                    if (isDone && (isEmpty || this.error.get() != null)) {
                        this.terminateDownstream(downstream);
                        this.upstreamCanceled = true;
                        continue;
                    }
                    if (!isEmpty) {
                        if (o instanceof WindowStartItem) {
                            if (this.downstreamCancelled.get()) continue;
                            long emitted = this.emitted;
                            if (this.requested.get() != emitted) {
                                Publisher<V> endSource;
                                this.emitted = ++emitted;
                                Object startItem = ((WindowStartItem)o).item;
                                try {
                                    endSource = Objects.requireNonNull(this.closingIndicator.apply(startItem), "The closingIndicator returned a null Publisher");
                                }
                                catch (Throwable ex) {
                                    Exceptions.throwIfFatal(ex);
                                    this.upstream.cancel();
                                    this.startSubscriber.cancel();
                                    this.resources.dispose();
                                    Exceptions.throwIfFatal(ex);
                                    this.error.tryAddThrowableOrReport(ex);
                                    this.upstreamDone = true;
                                    continue;
                                }
                                this.windowCount.getAndIncrement();
                                UnicastProcessor newWindow = UnicastProcessor.create(this.bufferSize, this);
                                WindowEndSubscriberIntercept endSubscriber = new WindowEndSubscriberIntercept(this, newWindow);
                                downstream.onNext(endSubscriber);
                                if (endSubscriber.tryAbandon()) {
                                    newWindow.onComplete();
                                    continue;
                                }
                                windows.add(newWindow);
                                this.resources.add(endSubscriber);
                                endSource.subscribe(endSubscriber);
                                continue;
                            }
                            this.upstream.cancel();
                            this.startSubscriber.cancel();
                            this.resources.dispose();
                            this.error.tryAddThrowableOrReport(new MissingBackpressureException(FlowableWindowTimed.missingBackpressureMessage(emitted)));
                            this.upstreamDone = true;
                            continue;
                        }
                        if (o instanceof WindowEndSubscriberIntercept) {
                            UnicastProcessor w = ((WindowEndSubscriberIntercept)o).window;
                            windows.remove(w);
                            this.resources.delete((Disposable)o);
                            w.onComplete();
                            continue;
                        }
                        Object item = o;
                        Iterator<UnicastProcessor<T>> iterator = windows.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block2;
                            UnicastProcessor<Object> w = iterator.next();
                            w.onNext(item);
                        }
                    }
                    if (this.openDone && windows.size() == 0) {
                        this.upstream.cancel();
                        this.startSubscriber.cancel();
                        this.resources.dispose();
                        this.terminateDownstream(downstream);
                        this.upstreamCanceled = true;
                        continue;
                    }
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        void terminateDownstream(Subscriber<?> downstream) {
            Throwable ex = this.error.terminate();
            if (ex == null) {
                for (UnicastProcessor<T> w : this.windows) {
                    w.onComplete();
                }
                downstream.onComplete();
            } else if (ex != ExceptionHelper.TERMINATED) {
                for (UnicastProcessor<T> w : this.windows) {
                    w.onError(ex);
                }
                downstream.onError(ex);
            }
        }

        static final class WindowEndSubscriberIntercept<T, V>
        extends Flowable<T>
        implements FlowableSubscriber<V>,
        Disposable {
            final WindowBoundaryMainSubscriber<T, ?, V> parent;
            final UnicastProcessor<T> window;
            final AtomicReference<Subscription> upstream;
            final AtomicBoolean once;

            WindowEndSubscriberIntercept(WindowBoundaryMainSubscriber<T, ?, V> parent, UnicastProcessor<T> window) {
                this.parent = parent;
                this.window = window;
                this.upstream = new AtomicReference();
                this.once = new AtomicBoolean();
            }

            @Override
            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce(this.upstream, s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(V t) {
                if (SubscriptionHelper.cancel(this.upstream)) {
                    this.parent.close(this);
                }
            }

            @Override
            public void onError(Throwable t) {
                if (this.isDisposed()) {
                    RxJavaPlugins.onError(t);
                } else {
                    this.parent.closeError(t);
                }
            }

            @Override
            public void onComplete() {
                this.parent.close(this);
            }

            @Override
            public void dispose() {
                SubscriptionHelper.cancel(this.upstream);
            }

            @Override
            public boolean isDisposed() {
                return this.upstream.get() == SubscriptionHelper.CANCELLED;
            }

            @Override
            protected void subscribeActual(Subscriber<? super T> s) {
                this.window.subscribe(s);
                this.once.set(true);
            }

            boolean tryAbandon() {
                return !this.once.get() && this.once.compareAndSet(false, true);
            }
        }

        static final class WindowStartSubscriber<B>
        extends AtomicReference<Subscription>
        implements FlowableSubscriber<B> {
            private static final long serialVersionUID = -3326496781427702834L;
            final WindowBoundaryMainSubscriber<?, B, ?> parent;

            WindowStartSubscriber(WindowBoundaryMainSubscriber<?, B, ?> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.setOnce(this, s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(B t) {
                this.parent.open(t);
            }

            @Override
            public void onError(Throwable t) {
                this.parent.openError(t);
            }

            @Override
            public void onComplete() {
                this.parent.openComplete();
            }

            void cancel() {
                SubscriptionHelper.cancel(this);
            }
        }

        static final class WindowStartItem<B> {
            final B item;

            WindowStartItem(B item) {
                this.item = item;
            }
        }
    }
}

