/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.concurrent.atomic.AtomicLong;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.core.FlowableSubscriber;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import shadow.io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import shadow.io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;
import shadow.org.reactivestreams.Subscriber;
import shadow.org.reactivestreams.Subscription;

public final class FlowableTake<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long n;

    public FlowableTake(Flowable<T> source, long n) {
        super(source);
        this.n = n;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new TakeSubscriber<T>(s, this.n));
    }

    static final class TakeSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 2288246011222124525L;
        final Subscriber<? super T> downstream;
        long remaining;
        Subscription upstream;

        TakeSubscriber(Subscriber<? super T> actual, long remaining) {
            this.downstream = actual;
            this.remaining = remaining;
            this.lazySet(remaining);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                if (this.remaining == 0L) {
                    s.cancel();
                    EmptySubscription.complete(this.downstream);
                } else {
                    this.upstream = s;
                    this.downstream.onSubscribe(this);
                }
            }
        }

        @Override
        public void onNext(T t) {
            long r = this.remaining;
            if (r > 0L) {
                this.remaining = --r;
                this.downstream.onNext(t);
                if (r == 0L) {
                    this.upstream.cancel();
                    this.downstream.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.remaining > 0L) {
                this.remaining = 0L;
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.remaining > 0L) {
                this.remaining = 0L;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long r;
                while ((r = this.get()) != 0L) {
                    long toRequest = Math.min(r, n);
                    long u = r - toRequest;
                    if (!this.compareAndSet(r, u)) continue;
                    this.upstream.request(toRequest);
                    break;
                }
            }
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

