/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.core.FlowableSubscriber;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import shadow.io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import shadow.io.reactivex.rxjava3.internal.subscriptions.SubscriptionArbiter;
import shadow.io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import shadow.io.reactivex.rxjava3.processors.FlowableProcessor;
import shadow.io.reactivex.rxjava3.processors.UnicastProcessor;
import shadow.io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import shadow.org.reactivestreams.Publisher;
import shadow.org.reactivestreams.Subscriber;
import shadow.org.reactivestreams.Subscription;

public final class FlowableRepeatWhen<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Function<? super Flowable<Object>, ? extends Publisher<?>> handler;

    public FlowableRepeatWhen(Flowable<T> source, Function<? super Flowable<Object>, ? extends Publisher<?>> handler) {
        super(source);
        this.handler = handler;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Publisher<?> when;
        SerializedSubscriber<? super T> z = new SerializedSubscriber<T>(s);
        FlowableProcessor<Object> processor = UnicastProcessor.create(8).toSerialized();
        try {
            when = Objects.requireNonNull(this.handler.apply(processor), "handler returned a null Publisher");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptySubscription.error(ex, s);
            return;
        }
        WhenReceiver receiver = new WhenReceiver(this.source);
        RepeatWhenSubscriber subscriber = new RepeatWhenSubscriber(z, processor, (Subscription)receiver);
        receiver.subscriber = subscriber;
        s.onSubscribe(subscriber);
        when.subscribe(receiver);
        receiver.onNext((Object)0);
    }

    static final class RepeatWhenSubscriber<T>
    extends WhenSourceSubscriber<T, Object> {
        private static final long serialVersionUID = -2680129890138081029L;

        RepeatWhenSubscriber(Subscriber<? super T> actual, FlowableProcessor<Object> processor, Subscription receiver) {
            super(actual, processor, receiver);
        }

        @Override
        public void onError(Throwable t) {
            this.receiver.cancel();
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.again(0);
        }
    }

    static abstract class WhenSourceSubscriber<T, U>
    extends SubscriptionArbiter
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -5604623027276966720L;
        protected final Subscriber<? super T> downstream;
        protected final FlowableProcessor<U> processor;
        protected final Subscription receiver;
        private long produced;

        WhenSourceSubscriber(Subscriber<? super T> actual, FlowableProcessor<U> processor, Subscription receiver) {
            super(false);
            this.downstream = actual;
            this.processor = processor;
            this.receiver = receiver;
        }

        @Override
        public final void onSubscribe(Subscription s) {
            this.setSubscription(s);
        }

        @Override
        public final void onNext(T t) {
            ++this.produced;
            this.downstream.onNext(t);
        }

        protected final void again(U signal) {
            this.setSubscription(EmptySubscription.INSTANCE);
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.receiver.request(1L);
            this.processor.onNext(signal);
        }

        @Override
        public final void cancel() {
            super.cancel();
            this.receiver.cancel();
        }
    }

    static final class WhenReceiver<T, U>
    extends AtomicInteger
    implements FlowableSubscriber<Object>,
    Subscription {
        private static final long serialVersionUID = 2827772011130406689L;
        final Publisher<T> source;
        final AtomicReference<Subscription> upstream;
        final AtomicLong requested;
        WhenSourceSubscriber<T, U> subscriber;

        WhenReceiver(Publisher<T> source) {
            this.source = source;
            this.upstream = new AtomicReference();
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce(this.upstream, this.requested, s);
        }

        @Override
        public void onNext(Object t) {
            block2: {
                if (this.getAndIncrement() != 0) break block2;
                do {
                    if (this.upstream.get() == SubscriptionHelper.CANCELLED) {
                        return;
                    }
                    this.source.subscribe(this.subscriber);
                } while (this.decrementAndGet() != 0);
            }
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.cancel();
            this.subscriber.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            this.subscriber.cancel();
            this.subscriber.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            SubscriptionHelper.deferredRequest(this.upstream, this.requested, n);
        }

        @Override
        public void cancel() {
            SubscriptionHelper.cancel(this.upstream);
        }
    }
}

