/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.core.Single;
import shadow.io.reactivex.rxjava3.core.SingleObserver;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.BiFunction;
import shadow.io.reactivex.rxjava3.functions.Supplier;
import shadow.io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.FlowableReduceSeedSingle;
import shadow.org.reactivestreams.Publisher;

public final class FlowableReduceWithSingle<T, R>
extends Single<R> {
    final Publisher<T> source;
    final Supplier<R> seedSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public FlowableReduceWithSingle(Publisher<T> source, Supplier<R> seedSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source;
        this.seedSupplier = seedSupplier;
        this.reducer = reducer;
    }

    @Override
    protected void subscribeActual(SingleObserver<? super R> observer) {
        R seed;
        try {
            seed = Objects.requireNonNull(this.seedSupplier.get(), "The seedSupplier returned a null value");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.source.subscribe(new FlowableReduceSeedSingle.ReduceSeedObserver<T, R>(observer, this.reducer, seed));
    }
}

