/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.concurrent.atomic.AtomicLong;
import shadow.io.reactivex.rxjava3.annotations.Nullable;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.core.FlowableSubscriber;
import shadow.io.reactivex.rxjava3.core.Scheduler;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import shadow.io.reactivex.rxjava3.internal.subscriptions.BasicIntQueueSubscription;
import shadow.io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import shadow.io.reactivex.rxjava3.internal.util.BackpressureHelper;
import shadow.io.reactivex.rxjava3.operators.ConditionalSubscriber;
import shadow.io.reactivex.rxjava3.operators.QueueSubscription;
import shadow.io.reactivex.rxjava3.operators.SimpleQueue;
import shadow.io.reactivex.rxjava3.operators.SpscArrayQueue;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;
import shadow.org.reactivestreams.Subscriber;
import shadow.org.reactivestreams.Subscription;

public final class FlowableObserveOn<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Scheduler scheduler;
    final boolean delayError;
    final int prefetch;

    public FlowableObserveOn(Flowable<T> source, Scheduler scheduler, boolean delayError, int prefetch) {
        super(source);
        this.scheduler = scheduler;
        this.delayError = delayError;
        this.prefetch = prefetch;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Scheduler.Worker worker = this.scheduler.createWorker();
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new ObserveOnConditionalSubscriber((ConditionalSubscriber)s, worker, this.delayError, this.prefetch));
        } else {
            this.source.subscribe(new ObserveOnSubscriber<T>(s, worker, this.delayError, this.prefetch));
        }
    }

    static final class ObserveOnConditionalSubscriber<T>
    extends BaseObserveOnSubscriber<T> {
        private static final long serialVersionUID = 644624475404284533L;
        final ConditionalSubscriber<? super T> downstream;
        long consumed;

        ObserveOnConditionalSubscriber(ConditionalSubscriber<? super T> actual, Scheduler.Worker worker, boolean delayError, int prefetch) {
            super(worker, delayError, prefetch);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription f = (QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.downstream.onSubscribe(this);
                        s.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue(this.prefetch);
                this.downstream.onSubscribe(this);
                s.request(this.prefetch);
            }
        }

        @Override
        void runSync() {
            int missed = 1;
            ConditionalSubscriber a = this.downstream;
            SimpleQueue q = this.queue;
            long e = this.produced;
            do {
                long r = this.requested.get();
                while (e != r) {
                    Object v;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelled = true;
                        this.upstream.cancel();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (v == null) {
                        this.cancelled = true;
                        a.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (!a.tryOnNext(v)) continue;
                    ++e;
                }
                if (this.cancelled) {
                    return;
                }
                if (q.isEmpty()) {
                    this.cancelled = true;
                    a.onComplete();
                    this.worker.dispose();
                    return;
                }
                this.produced = e;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        void runAsync() {
            int missed = 1;
            ConditionalSubscriber a = this.downstream;
            SimpleQueue q = this.queue;
            long emitted = this.produced;
            long polled = this.consumed;
            do {
                long r = this.requested.get();
                while (emitted != r) {
                    boolean empty;
                    Object v;
                    boolean d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelled = true;
                        this.upstream.cancel();
                        q.clear();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    if (a.tryOnNext(v)) {
                        ++emitted;
                    }
                    if (++polled != (long)this.limit) continue;
                    this.upstream.request(polled);
                    polled = 0L;
                }
                if (emitted == r && this.checkTerminated(this.done, q.isEmpty(), a)) {
                    return;
                }
                this.produced = emitted;
                this.consumed = polled;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        void runBackfused() {
            int missed = 1;
            do {
                if (this.cancelled) {
                    return;
                }
                boolean d = this.done;
                this.downstream.onNext(null);
                if (!d) continue;
                this.cancelled = true;
                Throwable e = this.error;
                if (e != null) {
                    this.downstream.onError(e);
                } else {
                    this.downstream.onComplete();
                }
                this.worker.dispose();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v = this.queue.poll();
            if (v != null && this.sourceMode != 1) {
                long p = this.consumed + 1L;
                if (p == (long)this.limit) {
                    this.consumed = 0L;
                    this.upstream.request(p);
                } else {
                    this.consumed = p;
                }
            }
            return v;
        }
    }

    static final class ObserveOnSubscriber<T>
    extends BaseObserveOnSubscriber<T>
    implements FlowableSubscriber<T> {
        private static final long serialVersionUID = -4547113800637756442L;
        final Subscriber<? super T> downstream;

        ObserveOnSubscriber(Subscriber<? super T> actual, Scheduler.Worker worker, boolean delayError, int prefetch) {
            super(worker, delayError, prefetch);
            this.downstream = actual;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                if (s instanceof QueueSubscription) {
                    QueueSubscription f = (QueueSubscription)s;
                    int m = f.requestFusion(7);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.downstream.onSubscribe(this);
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                        this.downstream.onSubscribe(this);
                        s.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue(this.prefetch);
                this.downstream.onSubscribe(this);
                s.request(this.prefetch);
            }
        }

        @Override
        void runSync() {
            int missed = 1;
            Subscriber a = this.downstream;
            SimpleQueue q = this.queue;
            long e = this.produced;
            do {
                long r = this.requested.get();
                while (e != r) {
                    Object v;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelled = true;
                        this.upstream.cancel();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    if (this.cancelled) {
                        return;
                    }
                    if (v == null) {
                        this.cancelled = true;
                        a.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    a.onNext(v);
                    ++e;
                }
                if (this.cancelled) {
                    return;
                }
                if (q.isEmpty()) {
                    this.cancelled = true;
                    a.onComplete();
                    this.worker.dispose();
                    return;
                }
                this.produced = e;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        void runAsync() {
            int missed = 1;
            Subscriber a = this.downstream;
            SimpleQueue q = this.queue;
            long e = this.produced;
            while (true) {
                long r = this.requested.get();
                while (e != r) {
                    boolean empty;
                    Object v;
                    boolean d = this.done;
                    try {
                        v = q.poll();
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancelled = true;
                        this.upstream.cancel();
                        q.clear();
                        a.onError(ex);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                    if (++e != (long)this.limit) continue;
                    if (r != Long.MAX_VALUE) {
                        r = this.requested.addAndGet(-e);
                    }
                    this.upstream.request(e);
                    e = 0L;
                }
                if (e == r && this.checkTerminated(this.done, q.isEmpty(), a)) {
                    return;
                }
                int w = this.get();
                if (missed == w) {
                    this.produced = e;
                    if ((missed = this.addAndGet(-missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        @Override
        void runBackfused() {
            int missed = 1;
            do {
                if (this.cancelled) {
                    return;
                }
                boolean d = this.done;
                this.downstream.onNext(null);
                if (!d) continue;
                this.cancelled = true;
                Throwable e = this.error;
                if (e != null) {
                    this.downstream.onError(e);
                } else {
                    this.downstream.onComplete();
                }
                this.worker.dispose();
                return;
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        @Override
        @Nullable
        public T poll() throws Throwable {
            Object v = this.queue.poll();
            if (v != null && this.sourceMode != 1) {
                long p = this.produced + 1L;
                if (p == (long)this.limit) {
                    this.produced = 0L;
                    this.upstream.request(p);
                } else {
                    this.produced = p;
                }
            }
            return v;
        }
    }

    static abstract class BaseObserveOnSubscriber<T>
    extends BasicIntQueueSubscription<T>
    implements FlowableSubscriber<T>,
    Runnable {
        private static final long serialVersionUID = -8241002408341274697L;
        final Scheduler.Worker worker;
        final boolean delayError;
        final int prefetch;
        final int limit;
        final AtomicLong requested;
        Subscription upstream;
        SimpleQueue<T> queue;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        int sourceMode;
        long produced;
        boolean outputFused;

        BaseObserveOnSubscriber(Scheduler.Worker worker, boolean delayError, int prefetch) {
            this.worker = worker;
            this.delayError = delayError;
            this.prefetch = prefetch;
            this.requested = new AtomicLong();
            this.limit = prefetch - (prefetch >> 2);
        }

        @Override
        public final void onNext(T t) {
            if (this.done) {
                return;
            }
            if (this.sourceMode == 2) {
                this.trySchedule();
                return;
            }
            if (!this.queue.offer(t)) {
                this.upstream.cancel();
                this.error = new MissingBackpressureException("Queue is full?!");
                this.done = true;
            }
            this.trySchedule();
        }

        @Override
        public final void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.trySchedule();
        }

        @Override
        public final void onComplete() {
            if (!this.done) {
                this.done = true;
                this.trySchedule();
            }
        }

        @Override
        public final void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.trySchedule();
            }
        }

        @Override
        public final void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.upstream.cancel();
            this.worker.dispose();
            if (!this.outputFused && this.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        final void trySchedule() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            this.worker.schedule(this);
        }

        @Override
        public final void run() {
            if (this.outputFused) {
                this.runBackfused();
            } else if (this.sourceMode == 1) {
                this.runSync();
            } else {
                this.runAsync();
            }
        }

        abstract void runBackfused();

        abstract void runSync();

        abstract void runAsync();

        final boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a) {
            if (this.cancelled) {
                this.clear();
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        this.cancelled = true;
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        this.worker.dispose();
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.cancelled = true;
                        this.clear();
                        a.onError(e);
                        this.worker.dispose();
                        return true;
                    }
                    if (empty) {
                        this.cancelled = true;
                        a.onComplete();
                        this.worker.dispose();
                        return true;
                    }
                }
            }
            return false;
        }

        @Override
        public final int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.outputFused = true;
                return 2;
            }
            return 0;
        }

        @Override
        public final void clear() {
            this.queue.clear();
        }

        @Override
        public final boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

