/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.annotations.Nullable;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import shadow.io.reactivex.rxjava3.internal.subscribers.BasicFuseableConditionalSubscriber;
import shadow.io.reactivex.rxjava3.internal.subscribers.BasicFuseableSubscriber;
import shadow.io.reactivex.rxjava3.operators.ConditionalSubscriber;
import shadow.org.reactivestreams.Subscriber;

public final class FlowableMap<T, U>
extends AbstractFlowableWithUpstream<T, U> {
    final Function<? super T, ? extends U> mapper;

    public FlowableMap(Flowable<T> source, Function<? super T, ? extends U> mapper) {
        super(source);
        this.mapper = mapper;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s) {
        if (s instanceof ConditionalSubscriber) {
            this.source.subscribe(new MapConditionalSubscriber<T, U>((ConditionalSubscriber)s, this.mapper));
        } else {
            this.source.subscribe(new MapSubscriber<T, U>(s, this.mapper));
        }
    }

    static final class MapConditionalSubscriber<T, U>
    extends BasicFuseableConditionalSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapConditionalSubscriber(ConditionalSubscriber<? super U> actual, Function<? super T, ? extends U> function) {
            super(actual);
            this.mapper = function;
        }

        @Override
        public void onNext(T t) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v = Objects.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.downstream.onNext(v);
        }

        @Override
        public boolean tryOnNext(T t) {
            U v;
            if (this.done) {
                return true;
            }
            if (this.sourceMode != 0) {
                this.downstream.tryOnNext(null);
                return true;
            }
            try {
                v = Objects.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return true;
            }
            return this.downstream.tryOnNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Throwable {
            Object t = this.qs.poll();
            return t != null ? (U)Objects.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.") : null;
        }
    }

    static final class MapSubscriber<T, U>
    extends BasicFuseableSubscriber<T, U> {
        final Function<? super T, ? extends U> mapper;

        MapSubscriber(Subscriber<? super U> actual, Function<? super T, ? extends U> mapper) {
            super(actual);
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t) {
            U v;
            if (this.done) {
                return;
            }
            if (this.sourceMode != 0) {
                this.downstream.onNext(null);
                return;
            }
            try {
                v = Objects.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.");
            }
            catch (Throwable ex) {
                this.fail(ex);
                return;
            }
            this.downstream.onNext(v);
        }

        @Override
        public int requestFusion(int mode) {
            return this.transitiveBoundaryFusion(mode);
        }

        @Override
        @Nullable
        public U poll() throws Throwable {
            Object t = this.qs.poll();
            return t != null ? (U)Objects.requireNonNull(this.mapper.apply(t), "The mapper function returned a null value.") : null;
        }
    }
}

