/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import shadow.io.reactivex.rxjava3.core.Emitter;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.core.Scheduler;
import shadow.io.reactivex.rxjava3.flowables.ConnectableFlowable;
import shadow.io.reactivex.rxjava3.functions.Action;
import shadow.io.reactivex.rxjava3.functions.BiConsumer;
import shadow.io.reactivex.rxjava3.functions.BiFunction;
import shadow.io.reactivex.rxjava3.functions.Consumer;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.functions.Supplier;
import shadow.io.reactivex.rxjava3.internal.functions.Functions;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.FlowableFromIterable;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.FlowableMapPublisher;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.FlowableTakePublisher;
import shadow.org.reactivestreams.Publisher;
import shadow.org.reactivestreams.Subscriber;
import shadow.org.reactivestreams.Subscription;

public final class FlowableInternalHelper {
    private FlowableInternalHelper() {
        throw new IllegalStateException("No instances!");
    }

    public static <T, S> BiFunction<S, Emitter<T>, S> simpleGenerator(Consumer<Emitter<T>> consumer) {
        return new SimpleGenerator(consumer);
    }

    public static <T, S> BiFunction<S, Emitter<T>, S> simpleBiGenerator(BiConsumer<S, Emitter<T>> consumer) {
        return new SimpleBiGenerator<T, S>(consumer);
    }

    public static <T, U> Function<T, Publisher<T>> itemDelay(Function<? super T, ? extends Publisher<U>> itemDelay) {
        return new ItemDelayFunction(itemDelay);
    }

    public static <T> Consumer<T> subscriberOnNext(Subscriber<T> subscriber) {
        return new SubscriberOnNext<T>(subscriber);
    }

    public static <T> Consumer<Throwable> subscriberOnError(Subscriber<T> subscriber) {
        return new SubscriberOnError<T>(subscriber);
    }

    public static <T> Action subscriberOnComplete(Subscriber<T> subscriber) {
        return new SubscriberOnComplete<T>(subscriber);
    }

    public static <T, U, R> Function<T, Publisher<R>> flatMapWithCombiner(Function<? super T, ? extends Publisher<? extends U>> mapper, BiFunction<? super T, ? super U, ? extends R> combiner) {
        return new FlatMapWithCombinerOuter<T, R, U>(combiner, mapper);
    }

    public static <T, U> Function<T, Publisher<U>> flatMapIntoIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        return new FlatMapIntoIterable(mapper);
    }

    public static <T> Supplier<ConnectableFlowable<T>> replaySupplier(Flowable<T> parent) {
        return new ReplaySupplier<T>(parent);
    }

    public static <T> Supplier<ConnectableFlowable<T>> replaySupplier(Flowable<T> parent, int bufferSize, boolean eagerTruncate) {
        return new BufferedReplaySupplier<T>(parent, bufferSize, eagerTruncate);
    }

    public static <T> Supplier<ConnectableFlowable<T>> replaySupplier(Flowable<T> parent, int bufferSize, long time, TimeUnit unit, Scheduler scheduler, boolean eagerTruncate) {
        return new BufferedTimedReplay<T>(parent, bufferSize, time, unit, scheduler, eagerTruncate);
    }

    public static <T> Supplier<ConnectableFlowable<T>> replaySupplier(Flowable<T> parent, long time, TimeUnit unit, Scheduler scheduler, boolean eagerTruncate) {
        return new TimedReplay<T>(parent, time, unit, scheduler, eagerTruncate);
    }

    static final class TimedReplay<T>
    implements Supplier<ConnectableFlowable<T>> {
        private final Flowable<T> parent;
        private final long time;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        final boolean eagerTruncate;

        TimedReplay(Flowable<T> parent, long time, TimeUnit unit, Scheduler scheduler, boolean eagerTruncate) {
            this.parent = parent;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.eagerTruncate = eagerTruncate;
        }

        @Override
        public ConnectableFlowable<T> get() {
            return this.parent.replay(this.time, this.unit, this.scheduler, this.eagerTruncate);
        }
    }

    static final class BufferedTimedReplay<T>
    implements Supplier<ConnectableFlowable<T>> {
        final Flowable<T> parent;
        final int bufferSize;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final boolean eagerTruncate;

        BufferedTimedReplay(Flowable<T> parent, int bufferSize, long time, TimeUnit unit, Scheduler scheduler, boolean eagerTruncate) {
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.eagerTruncate = eagerTruncate;
        }

        @Override
        public ConnectableFlowable<T> get() {
            return this.parent.replay(this.bufferSize, this.time, this.unit, this.scheduler, this.eagerTruncate);
        }
    }

    static final class BufferedReplaySupplier<T>
    implements Supplier<ConnectableFlowable<T>> {
        final Flowable<T> parent;
        final int bufferSize;
        final boolean eagerTruncate;

        BufferedReplaySupplier(Flowable<T> parent, int bufferSize, boolean eagerTruncate) {
            this.parent = parent;
            this.bufferSize = bufferSize;
            this.eagerTruncate = eagerTruncate;
        }

        @Override
        public ConnectableFlowable<T> get() {
            return this.parent.replay(this.bufferSize, this.eagerTruncate);
        }
    }

    static final class ReplaySupplier<T>
    implements Supplier<ConnectableFlowable<T>> {
        final Flowable<T> parent;

        ReplaySupplier(Flowable<T> parent) {
            this.parent = parent;
        }

        @Override
        public ConnectableFlowable<T> get() {
            return this.parent.replay();
        }
    }

    public static enum RequestMax implements Consumer<Subscription>
    {
        INSTANCE;


        @Override
        public void accept(Subscription t) {
            t.request(Long.MAX_VALUE);
        }
    }

    static final class FlatMapIntoIterable<T, U>
    implements Function<T, Publisher<U>> {
        private final Function<? super T, ? extends Iterable<? extends U>> mapper;

        FlatMapIntoIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
            this.mapper = mapper;
        }

        @Override
        public Publisher<U> apply(T t) throws Throwable {
            return new FlowableFromIterable<U>(Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Iterable"));
        }
    }

    static final class FlatMapWithCombinerOuter<T, R, U>
    implements Function<T, Publisher<R>> {
        private final BiFunction<? super T, ? super U, ? extends R> combiner;
        private final Function<? super T, ? extends Publisher<? extends U>> mapper;

        FlatMapWithCombinerOuter(BiFunction<? super T, ? super U, ? extends R> combiner, Function<? super T, ? extends Publisher<? extends U>> mapper) {
            this.combiner = combiner;
            this.mapper = mapper;
        }

        @Override
        public Publisher<R> apply(T t) throws Throwable {
            Publisher<? extends U> u = Objects.requireNonNull(this.mapper.apply(t), "The mapper returned a null Publisher");
            return new FlowableMapPublisher(u, new FlatMapWithCombinerInner<U, R, T>(this.combiner, t));
        }
    }

    static final class FlatMapWithCombinerInner<U, R, T>
    implements Function<U, R> {
        private final BiFunction<? super T, ? super U, ? extends R> combiner;
        private final T t;

        FlatMapWithCombinerInner(BiFunction<? super T, ? super U, ? extends R> combiner, T t) {
            this.combiner = combiner;
            this.t = t;
        }

        @Override
        public R apply(U w) throws Throwable {
            return this.combiner.apply(this.t, w);
        }
    }

    static final class SubscriberOnComplete<T>
    implements Action {
        final Subscriber<T> subscriber;

        SubscriberOnComplete(Subscriber<T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void run() {
            this.subscriber.onComplete();
        }
    }

    static final class SubscriberOnError<T>
    implements Consumer<Throwable> {
        final Subscriber<T> subscriber;

        SubscriberOnError(Subscriber<T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void accept(Throwable v) {
            this.subscriber.onError(v);
        }
    }

    static final class SubscriberOnNext<T>
    implements Consumer<T> {
        final Subscriber<T> subscriber;

        SubscriberOnNext(Subscriber<T> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void accept(T v) {
            this.subscriber.onNext(v);
        }
    }

    static final class ItemDelayFunction<T, U>
    implements Function<T, Publisher<T>> {
        final Function<? super T, ? extends Publisher<U>> itemDelay;

        ItemDelayFunction(Function<? super T, ? extends Publisher<U>> itemDelay) {
            this.itemDelay = itemDelay;
        }

        @Override
        public Publisher<T> apply(T v) throws Throwable {
            Publisher<U> p = Objects.requireNonNull(this.itemDelay.apply(v), "The itemDelay returned a null Publisher");
            return new FlowableTakePublisher<U>(p, 1L).map(Functions.justFunction(v)).defaultIfEmpty(v);
        }
    }

    static final class SimpleBiGenerator<T, S>
    implements BiFunction<S, Emitter<T>, S> {
        final BiConsumer<S, Emitter<T>> consumer;

        SimpleBiGenerator(BiConsumer<S, Emitter<T>> consumer) {
            this.consumer = consumer;
        }

        @Override
        public S apply(S t1, Emitter<T> t2) throws Throwable {
            this.consumer.accept(t1, t2);
            return t1;
        }
    }

    static final class SimpleGenerator<T, S>
    implements BiFunction<S, Emitter<T>, S> {
        final Consumer<Emitter<T>> consumer;

        SimpleGenerator(Consumer<Emitter<T>> consumer) {
            this.consumer = consumer;
        }

        @Override
        public S apply(S t1, Emitter<T> t2) throws Throwable {
            this.consumer.accept(t2);
            return t1;
        }
    }
}

