/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.Objects;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Supplier;
import shadow.io.reactivex.rxjava3.internal.subscriptions.DeferredScalarSubscription;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;
import shadow.org.reactivestreams.Subscriber;

public final class FlowableFromSupplier<T>
extends Flowable<T>
implements Supplier<T> {
    final Supplier<? extends T> supplier;

    public FlowableFromSupplier(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        T t;
        DeferredScalarSubscription<T> deferred = new DeferredScalarSubscription<T>(s);
        s.onSubscribe(deferred);
        try {
            t = Objects.requireNonNull(this.supplier.get(), "The supplier returned a null value");
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            if (deferred.isCancelled()) {
                RxJavaPlugins.onError(ex);
            } else {
                s.onError(ex);
            }
            return;
        }
        deferred.complete(t);
    }

    @Override
    public T get() throws Throwable {
        return Objects.requireNonNull(this.supplier.get(), "The supplier returned a null value");
    }
}

