/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import shadow.io.reactivex.rxjava3.core.Completable;
import shadow.io.reactivex.rxjava3.core.CompletableObserver;
import shadow.io.reactivex.rxjava3.core.CompletableSource;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.core.FlowableSubscriber;
import shadow.io.reactivex.rxjava3.disposables.CompositeDisposable;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.internal.fuseable.FuseToFlowable;
import shadow.io.reactivex.rxjava3.internal.operators.flowable.FlowableFlatMapCompletable;
import shadow.io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import shadow.io.reactivex.rxjava3.internal.util.AtomicThrowable;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;
import shadow.org.reactivestreams.Subscription;

public final class FlowableFlatMapCompletableCompletable<T>
extends Completable
implements FuseToFlowable<T> {
    final Flowable<T> source;
    final Function<? super T, ? extends CompletableSource> mapper;
    final int maxConcurrency;
    final boolean delayErrors;

    public FlowableFlatMapCompletableCompletable(Flowable<T> source, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors, int maxConcurrency) {
        this.source = source;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe((FlowableSubscriber<? super T>)new FlatMapCompletableMainSubscriber<T>(observer, this.mapper, this.delayErrors, this.maxConcurrency));
    }

    @Override
    public Flowable<T> fuseToFlowable() {
        return RxJavaPlugins.onAssembly(new FlowableFlatMapCompletable<T>(this.source, this.mapper, this.delayErrors, this.maxConcurrency));
    }

    static final class FlatMapCompletableMainSubscriber<T>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    Disposable {
        private static final long serialVersionUID = 8443155186132538303L;
        final CompletableObserver downstream;
        final AtomicThrowable errors;
        final Function<? super T, ? extends CompletableSource> mapper;
        final boolean delayErrors;
        final CompositeDisposable set;
        final int maxConcurrency;
        Subscription upstream;
        volatile boolean disposed;

        FlatMapCompletableMainSubscriber(CompletableObserver observer, Function<? super T, ? extends CompletableSource> mapper, boolean delayErrors, int maxConcurrency) {
            this.downstream = observer;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.errors = new AtomicThrowable();
            this.set = new CompositeDisposable();
            this.maxConcurrency = maxConcurrency;
            this.lazySet(1);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                int m = this.maxConcurrency;
                if (m == Integer.MAX_VALUE) {
                    s.request(Long.MAX_VALUE);
                } else {
                    s.request(m);
                }
            }
        }

        @Override
        public void onNext(T value) {
            CompletableSource cs;
            try {
                cs = Objects.requireNonNull(this.mapper.apply(value), "The mapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.cancel();
                this.onError(ex);
                return;
            }
            this.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.disposed && this.set.add(inner)) {
                cs.subscribe(inner);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                if (this.delayErrors) {
                    if (this.decrementAndGet() == 0) {
                        this.errors.tryTerminateConsumer(this.downstream);
                    } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                        this.upstream.request(1L);
                    }
                } else {
                    this.disposed = true;
                    this.upstream.cancel();
                    this.set.dispose();
                    this.errors.tryTerminateConsumer(this.downstream);
                }
            }
        }

        @Override
        public void onComplete() {
            if (this.decrementAndGet() == 0) {
                this.errors.tryTerminateConsumer(this.downstream);
            } else if (this.maxConcurrency != Integer.MAX_VALUE) {
                this.upstream.request(1L);
            }
        }

        @Override
        public void dispose() {
            this.disposed = true;
            this.upstream.cancel();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.set.isDisposed();
        }

        void innerComplete(InnerObserver inner) {
            this.set.delete(inner);
            this.onComplete();
        }

        void innerError(InnerObserver inner, Throwable e) {
            this.set.delete(inner);
            this.onError(e);
        }

        final class InnerObserver
        extends AtomicReference<Disposable>
        implements CompletableObserver,
        Disposable {
            private static final long serialVersionUID = 8606673141535671828L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d) {
                DisposableHelper.setOnce(this, d);
            }

            @Override
            public void onComplete() {
                FlatMapCompletableMainSubscriber.this.innerComplete(this);
            }

            @Override
            public void onError(Throwable e) {
                FlatMapCompletableMainSubscriber.this.innerError(this, e);
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }
        }
    }
}

