/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Supplier;
import shadow.io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import shadow.io.reactivex.rxjava3.internal.util.ExceptionHelper;
import shadow.org.reactivestreams.Subscriber;

public final class FlowableError<T>
extends Flowable<T> {
    final Supplier<? extends Throwable> errorSupplier;

    public FlowableError(Supplier<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s) {
        Throwable error;
        try {
            error = ExceptionHelper.nullCheck(this.errorSupplier.get(), "Callable returned a null Throwable.");
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            error = t;
        }
        EmptySubscription.error(error, s);
    }
}

