/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.flowable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import shadow.io.reactivex.rxjava3.core.Flowable;
import shadow.io.reactivex.rxjava3.core.Notification;
import shadow.io.reactivex.rxjava3.internal.util.BlockingHelper;
import shadow.io.reactivex.rxjava3.internal.util.ExceptionHelper;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;
import shadow.io.reactivex.rxjava3.subscribers.DisposableSubscriber;
import shadow.org.reactivestreams.Publisher;

public final class BlockingFlowableNext<T>
implements Iterable<T> {
    final Publisher<? extends T> source;

    public BlockingFlowableNext(Publisher<? extends T> source) {
        this.source = source;
    }

    @Override
    public Iterator<T> iterator() {
        NextSubscriber nextSubscriber = new NextSubscriber();
        return new NextIterator<T>(this.source, nextSubscriber);
    }

    static final class NextSubscriber<T>
    extends DisposableSubscriber<Notification<T>> {
        private final BlockingQueue<Notification<T>> buf = new ArrayBlockingQueue<Notification<T>>(1);
        final AtomicInteger waiting = new AtomicInteger();

        NextSubscriber() {
        }

        @Override
        public void onComplete() {
        }

        @Override
        public void onError(Throwable e) {
            RxJavaPlugins.onError(e);
        }

        @Override
        public void onNext(Notification<T> args) {
            if (this.waiting.getAndSet(0) == 1 || !args.isOnNext()) {
                Notification toOffer = args;
                while (!this.buf.offer(toOffer)) {
                    Notification concurrentItem = (Notification)this.buf.poll();
                    if (concurrentItem == null || concurrentItem.isOnNext()) continue;
                    toOffer = concurrentItem;
                }
            }
        }

        public Notification<T> takeNext() throws InterruptedException {
            this.setWaiting();
            BlockingHelper.verifyNonBlocking();
            return this.buf.take();
        }

        void setWaiting() {
            this.waiting.set(1);
        }
    }

    static final class NextIterator<T>
    implements Iterator<T> {
        private final NextSubscriber<T> subscriber;
        private final Publisher<? extends T> items;
        private T next;
        private boolean hasNext = true;
        private boolean isNextConsumed = true;
        private Throwable error;
        private boolean started;

        NextIterator(Publisher<? extends T> items, NextSubscriber<T> subscriber) {
            this.items = items;
            this.subscriber = subscriber;
        }

        @Override
        public boolean hasNext() {
            if (this.error != null) {
                throw ExceptionHelper.wrapOrThrow(this.error);
            }
            if (!this.hasNext) {
                return false;
            }
            return !this.isNextConsumed || this.moveToNext();
        }

        private boolean moveToNext() {
            try {
                Notification<T> nextNotification;
                if (!this.started) {
                    this.started = true;
                    this.subscriber.setWaiting();
                    Flowable.fromPublisher(this.items).materialize().subscribe(this.subscriber);
                }
                if ((nextNotification = this.subscriber.takeNext()).isOnNext()) {
                    this.isNextConsumed = false;
                    this.next = nextNotification.getValue();
                    return true;
                }
                this.hasNext = false;
                if (nextNotification.isOnComplete()) {
                    return false;
                }
                this.error = nextNotification.getError();
                throw ExceptionHelper.wrapOrThrow(this.error);
            }
            catch (InterruptedException e) {
                this.subscriber.dispose();
                this.error = e;
                throw ExceptionHelper.wrapOrThrow(e);
            }
        }

        @Override
        public T next() {
            if (this.error != null) {
                throw ExceptionHelper.wrapOrThrow(this.error);
            }
            if (this.hasNext()) {
                this.isNextConsumed = true;
                return this.next;
            }
            throw new NoSuchElementException("No more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read only iterator");
        }
    }
}

