/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.completable;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import shadow.io.reactivex.rxjava3.core.Completable;
import shadow.io.reactivex.rxjava3.core.CompletableObserver;
import shadow.io.reactivex.rxjava3.core.CompletableSource;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.CompositeException;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Function;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;

public final class CompletableResumeNext
extends Completable {
    final CompletableSource source;
    final Function<? super Throwable, ? extends CompletableSource> errorMapper;

    public CompletableResumeNext(CompletableSource source, Function<? super Throwable, ? extends CompletableSource> errorMapper) {
        this.source = source;
        this.errorMapper = errorMapper;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        ResumeNextObserver parent = new ResumeNextObserver(observer, this.errorMapper);
        observer.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class ResumeNextObserver
    extends AtomicReference<Disposable>
    implements CompletableObserver,
    Disposable {
        private static final long serialVersionUID = 5018523762564524046L;
        final CompletableObserver downstream;
        final Function<? super Throwable, ? extends CompletableSource> errorMapper;
        boolean once;

        ResumeNextObserver(CompletableObserver observer, Function<? super Throwable, ? extends CompletableSource> errorMapper) {
            this.downstream = observer;
            this.errorMapper = errorMapper;
        }

        @Override
        public void onSubscribe(Disposable d) {
            DisposableHelper.replace(this, d);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            CompletableSource c;
            if (this.once) {
                this.downstream.onError(e);
                return;
            }
            this.once = true;
            try {
                c = Objects.requireNonNull(this.errorMapper.apply(e), "The errorMapper returned a null CompletableSource");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(new CompositeException(e, ex));
                return;
            }
            c.subscribe(this);
        }

        @Override
        public boolean isDisposed() {
            return DisposableHelper.isDisposed((Disposable)this.get());
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }
}

