/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.completable;

import shadow.io.reactivex.rxjava3.core.Completable;
import shadow.io.reactivex.rxjava3.core.CompletableObserver;
import shadow.io.reactivex.rxjava3.core.CompletableSource;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.CompositeException;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Consumer;

public final class CompletableDoOnEvent
extends Completable {
    final CompletableSource source;
    final Consumer<? super Throwable> onEvent;

    public CompletableDoOnEvent(CompletableSource source, Consumer<? super Throwable> onEvent) {
        this.source = source;
        this.onEvent = onEvent;
    }

    @Override
    protected void subscribeActual(CompletableObserver observer) {
        this.source.subscribe(new DoOnEvent(observer));
    }

    final class DoOnEvent
    implements CompletableObserver {
        private final CompletableObserver observer;

        DoOnEvent(CompletableObserver observer) {
            this.observer = observer;
        }

        @Override
        public void onComplete() {
            try {
                CompletableDoOnEvent.this.onEvent.accept(null);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.observer.onError(e);
                return;
            }
            this.observer.onComplete();
        }

        @Override
        public void onError(Throwable e) {
            try {
                CompletableDoOnEvent.this.onEvent.accept(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                e = new CompositeException(e, ex);
            }
            this.observer.onError(e);
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.observer.onSubscribe(d);
        }
    }
}

