/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.operators.completable;

import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import shadow.io.reactivex.rxjava3.core.Completable;
import shadow.io.reactivex.rxjava3.core.CompletableObserver;
import shadow.io.reactivex.rxjava3.core.CompletableSource;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import shadow.io.reactivex.rxjava3.internal.disposables.SequentialDisposable;

public final class CompletableConcatIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableConcatIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        Iterator<? extends CompletableSource> it;
        try {
            it = Objects.requireNonNull(this.sources.iterator(), "The iterator returned is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, observer);
            return;
        }
        ConcatInnerObserver inner = new ConcatInnerObserver(observer, it);
        observer.onSubscribe(inner.sd);
        inner.next();
    }

    static final class ConcatInnerObserver
    extends AtomicInteger
    implements CompletableObserver {
        private static final long serialVersionUID = -7965400327305809232L;
        final CompletableObserver downstream;
        final Iterator<? extends CompletableSource> sources;
        final SequentialDisposable sd;

        ConcatInnerObserver(CompletableObserver actual, Iterator<? extends CompletableSource> sources) {
            this.downstream = actual;
            this.sources = sources;
            this.sd = new SequentialDisposable();
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.sd.replace(d);
        }

        @Override
        public void onError(Throwable e) {
            this.downstream.onError(e);
        }

        @Override
        public void onComplete() {
            this.next();
        }

        void next() {
            if (this.sd.isDisposed()) {
                return;
            }
            if (this.getAndIncrement() != 0) {
                return;
            }
            Iterator<? extends CompletableSource> a = this.sources;
            do {
                CompletableSource c;
                boolean b;
                if (this.sd.isDisposed()) {
                    return;
                }
                try {
                    b = a.hasNext();
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.downstream.onError(ex);
                    return;
                }
                if (!b) {
                    this.downstream.onComplete();
                    return;
                }
                try {
                    c = Objects.requireNonNull(a.next(), "The CompletableSource returned is null");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.downstream.onError(ex);
                    return;
                }
                c.subscribe(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

